/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.ftp.ssh;

import com.enterprisedt.net.ftp.FTPException;
import com.enterprisedt.net.ftp.FTPFile;
import com.enterprisedt.net.ftp.FTPProgressMonitor;
import com.enterprisedt.net.ftp.FTPTransferType;
import com.enterprisedt.net.ftp.FileTypes;
import com.enterprisedt.net.ftp.ProxyParameters;
import com.enterprisedt.net.ftp.RecursiveOperations;
import com.enterprisedt.net.ftp.VersionDetails;
import com.enterprisedt.net.ftp.WildcardFilter;
import com.enterprisedt.net.ftp.pro.ProFTPClientInterface;
import com.enterprisedt.net.ftp.ssh.A;
import com.enterprisedt.net.ftp.ssh.B;
import com.enterprisedt.net.ftp.ssh.SSHAuthPrompt;
import com.enterprisedt.net.ftp.ssh.SSHFTPAlgorithm;
import com.enterprisedt.net.ftp.ssh.SSHFTPException;
import com.enterprisedt.net.ftp.ssh.SSHFTPPublicKey;
import com.enterprisedt.net.ftp.ssh.SSHFTPValidator;
import com.enterprisedt.net.ftp.ssh.SSHPasswordPrompt;
import com.enterprisedt.net.j2ssh.FileTransferProgress;
import com.enterprisedt.net.j2ssh.SftpClient;
import com.enterprisedt.net.j2ssh.SshClient;
import com.enterprisedt.net.j2ssh.authentication.AuthenticationProtocolState;
import com.enterprisedt.net.j2ssh.authentication.KBIAuthenticationClient;
import com.enterprisedt.net.j2ssh.authentication.PasswordAuthenticationClient;
import com.enterprisedt.net.j2ssh.authentication.PublicKeyAuthenticationClient;
import com.enterprisedt.net.j2ssh.authentication.SshAuthenticationClient;
import com.enterprisedt.net.j2ssh.configuration.SshConnectionProperties;
import com.enterprisedt.net.j2ssh.sftp.FileAttributes;
import com.enterprisedt.net.j2ssh.sftp.SftpFile;
import com.enterprisedt.net.j2ssh.transport.AlgorithmNotSupportedException;
import com.enterprisedt.net.j2ssh.transport.cipher.SshCipherFactory;
import com.enterprisedt.net.j2ssh.transport.compression.SshCompressionFactory;
import com.enterprisedt.net.j2ssh.transport.hmac.SshHmacFactory;
import com.enterprisedt.net.j2ssh.transport.kex.SshKeyExchangeFactory;
import com.enterprisedt.net.j2ssh.transport.publickey.SshKeyPairFactory;
import com.enterprisedt.net.j2ssh.transport.publickey.SshPrivateKeyFile;
import com.enterprisedt.util.debug.Logger;
import com.enterprisedt.util.license.LicenseProperties;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

public class SSHFTPClient
implements ProFTPClientInterface {
    private Logger x = Logger.getLogger(class$com$enterprisedt$net$ftp$ssh$SSHFTPClient == null ? (class$com$enterprisedt$net$ftp$ssh$SSHFTPClient = SSHFTPClient.class$("com.enterprisedt.net.ftp.ssh.SSHFTPClient")) : class$com$enterprisedt$net$ftp$ssh$SSHFTPClient);
    public static final String DEFAULT_ENCODING = "US-ASCII";
    private static LicenseProperties w = new LicenseProperties();
    private B \u00c0 = new B();
    private SshClient \u00a3 = new SshClient();
    private SshConnectionProperties \u00b5 = new SshConnectionProperties();
    private SftpClient \u00a4 = null;
    private SSHFTPValidator v = new SSHFTPValidator();
    private SshAuthenticationClient \u00a2 = null;
    private SshAuthenticationClient y = null;
    public static final int DEFAULT_PORT = 22;
    private FTPTransferType t = FTPTransferType.BINARY;
    private RecursiveOperations q = new RecursiveOperations();
    private boolean z = true;
    private int s = -1;
    private boolean r = false;
    private boolean \u00ba = false;
    private int u = 0;
    private String \u00aa;
    private long \u00a5 = 0L;
    static /* synthetic */ Class class$com$enterprisedt$net$ftp$ssh$SSHFTPClient;

    public SSHFTPClient() {
        w.checkLicence();
        this.x.debug(VersionDetails.report(this));
        this.\u00b5.setPort(22);
        this.x.debug("Created SFTP client.");
    }

    public void setConfigFlags(int n2) throws FTPException {
        this.checkConnection(false);
        this.u = n2;
    }

    public int getConfigFlags() {
        return this.u;
    }

    public long getServerResponseTimeout() {
        return this.\u00a5;
    }

    public void setServerResponseTimeout(long l2) throws FTPException {
        this.checkConnection(false);
        this.\u00a5 = l2;
    }

    public void setControlEncoding(String string) throws FTPException {
        this.checkConnection(false);
        this.\u00aa = string;
    }

    public SSHFTPValidator getValidator() {
        return this.v;
    }

    public void setValidator(SSHFTPValidator sSHFTPValidator) throws FTPException {
        this.checkConnection(false);
        if (sSHFTPValidator == null) {
            throw new NullPointerException("Cannot set SSHFTPValidator to null");
        }
        this.v = sSHFTPValidator;
    }

    public static SSHFTPPublicKey getHostPublicKey(String string) throws FTPException {
        return SSHFTPClient.getHostPublicKey(string, 22);
    }

    public static SSHFTPPublicKey getHostPublicKey(String string, int n2) throws FTPException {
        SSHFTPClient sSHFTPClient = new SSHFTPClient();
        sSHFTPClient.setRemoteHost(string);
        sSHFTPClient.setRemotePort(n2);
        sSHFTPClient.setAuthentication("", "");
        try {
            sSHFTPClient.connect();
        }
        catch (Exception exception) {
            Logger logger = Logger.getLogger(class$com$enterprisedt$net$ftp$ssh$SSHFTPClient == null ? (class$com$enterprisedt$net$ftp$ssh$SSHFTPClient = SSHFTPClient.class$("com.enterprisedt.net.ftp.ssh.SSHFTPClient")) : class$com$enterprisedt$net$ftp$ssh$SSHFTPClient);
            logger.debug("Expected exception", exception);
        }
        return sSHFTPClient.getValidator().getHostPublicKey();
    }

    public SSHFTPPublicKey getHostPublicKey() {
        return this.v.getHostPublicKey();
    }

    public void setAuthentication(String string, String string2) throws FTPException {
        this.checkConnection(false);
        PasswordAuthenticationClient passwordAuthenticationClient = new PasswordAuthenticationClient();
        passwordAuthenticationClient.setUsername(string);
        passwordAuthenticationClient.setPassword(string2);
        this.\u00a2 = passwordAuthenticationClient;
        KBIAuthenticationClient kBIAuthenticationClient = new KBIAuthenticationClient();
        kBIAuthenticationClient.setUsername(string);
        SSHAuthPrompt[] sSHAuthPromptArray = new SSHAuthPrompt[]{new SSHPasswordPrompt(string2)};
        kBIAuthenticationClient.setKBIRequestHandler(new A(sSHAuthPromptArray));
        this.y = kBIAuthenticationClient;
    }

    public void setAuthentication(String string, SSHAuthPrompt[] sSHAuthPromptArray) throws FTPException {
        this.checkConnection(false);
        this.y = null;
        KBIAuthenticationClient kBIAuthenticationClient = new KBIAuthenticationClient();
        kBIAuthenticationClient.setUsername(string);
        kBIAuthenticationClient.setKBIRequestHandler(new A(sSHAuthPromptArray));
        this.\u00a2 = kBIAuthenticationClient;
        this.y = kBIAuthenticationClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAuthentication(String string, String string2, String string3) throws IOException, FTPException {
        FileInputStream fileInputStream = new FileInputStream(string);
        try {
            this.setAuthentication(fileInputStream, string2, string3);
        }
        finally {
            if (fileInputStream != null) {
                fileInputStream.close();
            }
        }
    }

    public void setAuthentication(InputStream inputStream, String string, String string2) throws IOException, FTPException {
        this.checkConnection(false);
        this.y = null;
        PublicKeyAuthenticationClient publicKeyAuthenticationClient = new PublicKeyAuthenticationClient();
        publicKeyAuthenticationClient.setUsername(string);
        SshPrivateKeyFile sshPrivateKeyFile = SshPrivateKeyFile.parse(inputStream);
        if (sshPrivateKeyFile.isPassphraseProtected()) {
            if (string2 == null) {
                throw new SSHFTPException("The key-file, " + sshPrivateKeyFile + ", is passphrase protected.  Please supply a passphrase.");
            }
            publicKeyAuthenticationClient.setKey(sshPrivateKeyFile.toPrivateKey(string2));
        } else {
            publicKeyAuthenticationClient.setKey(sshPrivateKeyFile.toPrivateKey(null));
        }
        this.\u00a2 = publicKeyAuthenticationClient;
    }

    private void E() throws SSHFTPException {
        if (this.getEnabledAlgorithms(0).length == 0) {
            throw new SSHFTPException("No cipher algorithms enabled.");
        }
        if (this.getEnabledAlgorithms(1).length == 0) {
            throw new SSHFTPException("No compression algorithms enabled.");
        }
        if (this.getEnabledAlgorithms(2).length == 0) {
            throw new SSHFTPException("No key-exchange algorithms enabled.");
        }
        if (this.getEnabledAlgorithms(3).length == 0) {
            throw new SSHFTPException("No key-pair algorithms enabled.");
        }
        if (this.getEnabledAlgorithms(4).length == 0) {
            throw new SSHFTPException("No MAC algorithms enabled.");
        }
        this.x.info("SSHFTPClient settings validated.");
    }

    public SSHFTPAlgorithm[] getEnabledAlgorithms() {
        try {
            ArrayList<SSHFTPAlgorithm> arrayList = new ArrayList<SSHFTPAlgorithm>();
            arrayList.addAll(Arrays.asList(this.getEnabledAlgorithms(0)));
            arrayList.addAll(Arrays.asList(this.getEnabledAlgorithms(1)));
            arrayList.addAll(Arrays.asList(this.getEnabledAlgorithms(2)));
            arrayList.addAll(Arrays.asList(this.getEnabledAlgorithms(3)));
            arrayList.addAll(Arrays.asList(this.getEnabledAlgorithms(4)));
            SSHFTPAlgorithm[] sSHFTPAlgorithmArray = new SSHFTPAlgorithm[arrayList.size()];
            arrayList.toArray(sSHFTPAlgorithmArray);
            return sSHFTPAlgorithmArray;
        }
        catch (SSHFTPException sSHFTPException) {
            throw new InternalError("Internal inconsistency getting all algorithms - " + sSHFTPException.getMessage());
        }
    }

    public SSHFTPAlgorithm[] getEnabledAlgorithms(int n2) throws SSHFTPException {
        List list = null;
        switch (n2) {
            case 0: {
                list = SshCipherFactory.getEnabledCiphers();
                break;
            }
            case 1: {
                list = SshCompressionFactory.getEnabledCompressions();
                break;
            }
            case 2: {
                list = SshKeyExchangeFactory.getEnabledKeyExchanges();
                break;
            }
            case 3: {
                list = SshKeyPairFactory.getEnabledKeyPairs();
                break;
            }
            case 4: {
                list = SshHmacFactory.getEnabledMacs();
                break;
            }
            default: {
                throw new SSHFTPException("No such algorithm type " + n2);
            }
        }
        SSHFTPAlgorithm[] sSHFTPAlgorithmArray = new SSHFTPAlgorithm[list.size()];
        for (int i2 = 0; i2 < list.size(); ++i2) {
            String string = (String)list.get(i2);
            if (string == null) {
                throw new InternalError("Internal inconsistency getting algorithm " + string);
            }
            sSHFTPAlgorithmArray[i2] = SSHFTPAlgorithm.getAlgorithm(string);
        }
        return sSHFTPAlgorithmArray;
    }

    public void disableAllAlgorithms(int n2) throws SSHFTPException {
        this.x.debug("Disabling all algorithms of type " + n2);
        switch (n2) {
            case 0: {
                SshCipherFactory.disableAllCiphers();
                break;
            }
            case 1: {
                SshCompressionFactory.disableAllCompressions();
                break;
            }
            case 2: {
                SshKeyExchangeFactory.disableAllKeyExchanges();
                break;
            }
            case 3: {
                SshKeyPairFactory.disableAllKeys();
                break;
            }
            case 4: {
                SshHmacFactory.disableAllMacs();
                break;
            }
            default: {
                throw new SSHFTPException("No such algorithm type " + n2);
            }
        }
    }

    public void disableAllAlgorithms() {
        this.x.debug("Disabling all algorithms.");
        SshCipherFactory.disableAllCiphers();
        SshCompressionFactory.disableAllCompressions();
        SshKeyExchangeFactory.disableAllKeyExchanges();
        SshKeyPairFactory.disableAllKeys();
        SshHmacFactory.disableAllMacs();
    }

    public void setAlgorithmEnabled(SSHFTPAlgorithm sSHFTPAlgorithm, boolean bl) {
        try {
            this.x.debug((bl ? "Enabling " : "Disabling ") + sSHFTPAlgorithm);
            switch (sSHFTPAlgorithm.getType()) {
                case 0: {
                    SshCipherFactory.setCipherEnabled(sSHFTPAlgorithm.getCode(), bl);
                    break;
                }
                case 1: {
                    SshCompressionFactory.setCompressionEnabled(sSHFTPAlgorithm.getCode(), bl);
                    break;
                }
                case 2: {
                    SshKeyExchangeFactory.setKeyExchangeEnabled(sSHFTPAlgorithm.getCode(), bl);
                    break;
                }
                case 3: {
                    SshKeyPairFactory.setKeyEnabled(sSHFTPAlgorithm.getCode(), bl);
                    break;
                }
                case 4: {
                    SshHmacFactory.setMacEnabled(sSHFTPAlgorithm.getCode(), bl);
                    break;
                }
                default: {
                    throw new InternalError("Internal inconsistency enabling algorithm (1) " + sSHFTPAlgorithm.getCode());
                }
            }
        }
        catch (AlgorithmNotSupportedException algorithmNotSupportedException) {
            throw new InternalError("Internal inconsistency enabling algorithm (2) " + sSHFTPAlgorithm.getCode());
        }
    }

    public void isAlgorithmEnabled(SSHFTPAlgorithm sSHFTPAlgorithm) {
        switch (sSHFTPAlgorithm.getType()) {
            case 0: {
                SshCipherFactory.isCipherEnabled(sSHFTPAlgorithm.getCode());
                break;
            }
            case 1: {
                SshCompressionFactory.isCompressionEnabled(sSHFTPAlgorithm.getCode());
                break;
            }
            case 2: {
                SshKeyExchangeFactory.isKeyExchangeEnabled(sSHFTPAlgorithm.getCode());
                break;
            }
            case 3: {
                SshKeyPairFactory.isKeyEnabled(sSHFTPAlgorithm.getCode());
                break;
            }
            case 4: {
                SshHmacFactory.isMacEnabled(sSHFTPAlgorithm.getCode());
                break;
            }
            default: {
                throw new InternalError("Internal inconsistency enabling algorithm (1) " + sSHFTPAlgorithm.getCode());
            }
        }
    }

    public String getRemoteHost() {
        return this.\u00b5.getHost();
    }

    public void setRemoteHost(String string) throws FTPException {
        this.checkConnection(false);
        this.\u00b5.setHost(string);
    }

    public int getRemotePort() {
        return this.\u00b5.getPort();
    }

    public void setRemotePort(int n2) throws FTPException {
        this.checkConnection(false);
        this.\u00b5.setPort(n2);
    }

    public void setProxyParams(ProxyParameters proxyParameters) {
        this.\u00b5.setProxyHost(proxyParameters.getProxyHost());
        this.\u00b5.setProxyPort(proxyParameters.getProxyPort());
        this.\u00b5.setProxyPassword(proxyParameters.getProxyPassword());
        this.\u00b5.setProxyUsername(proxyParameters.getProxyUsername());
    }

    public void setTransportProvider(int n2) {
        this.\u00b5.setTransportProvider(n2);
        this.x.debug("setTransportProvider(" + n2 + ")");
    }

    public int getTransportProvider() {
        return this.\u00b5.getTransportProvider();
    }

    public int getTimeout() {
        return this.\u00a3.getTimeout();
    }

    public void setTimeout(int n2) throws FTPException {
        this.checkConnection(false);
        this.\u00a3.setSocketTimeout(n2);
    }

    public void setDetectTransferMode(boolean bl) {
        this.z = bl;
    }

    public boolean getDetectTransferMode() {
        return this.z;
    }

    public int getMaxPacketSize() {
        return this.s;
    }

    public void setMaxPacketSize(int n2) throws FTPException {
        this.checkConnection(false);
        this.s = n2;
    }

    public FTPTransferType getType() {
        return this.t;
    }

    public void setType(FTPTransferType fTPTransferType) {
        this.t = fTPTransferType;
        if (this.\u00a4 != null) {
            this.\u00a4.setType(this.t);
            this.\u00a4.setRemoteEOL(this.\u00a3.getRemoteEOLString());
        }
    }

    public void resume() throws FTPException {
        if (this.t.equals(FTPTransferType.ASCII)) {
            throw new FTPException("Resume only supported for BINARY transfers");
        }
        this.r = true;
    }

    public void cancelResume() throws IOException, FTPException {
        this.r = false;
    }

    public void cancelTransfer() {
        this.x.debug("cancelTransfer() called");
        this.\u00c0.A();
    }

    public void connect() throws IOException, FTPException {
        int n2;
        this.checkConnection(false);
        if (this.getRemoteHost() == null) {
            throw new SSHFTPException("Remote host not set.");
        }
        if (this.\u00a2 == null) {
            throw new SSHFTPException("No user authenticator set.  Invoke one of the setAuthentication() methods before calling connect().");
        }
        this.E();
        this.x.debug("Connecting to " + this.\u00b5.getHost() + ":" + this.\u00b5.getPort());
        this.\u00a3.connect(this.\u00b5, this.v.A());
        int n3 = this.\u00a3.authenticate(this.\u00a2);
        if (n3 == 2 && this.y != null) {
            this.x.info("Authentication failed - trying alternative method");
            n3 = this.\u00a3.authenticate(this.y);
        }
        if (n3 == 4) {
            n2 = 0;
            if ((this.u & ConfigFlags.DISABLE_CHMOD_AFTER_PUT) != 0) {
                n2 |= 1;
            }
        } else {
            throw new SSHFTPException("Could not authenticate SSH client: " + AuthenticationProtocolState.toString(n3));
        }
        this.\u00a4 = this.\u00a3.openSftpClient(n2);
        this.\u00a4.setType(this.t);
        this.\u00a4.setRemoteEOL(this.\u00a3.getRemoteEOLString());
        this.\u00a4.setMaxPacketSize(this.s);
        this.\u00a4.setControlEncoding(this.\u00aa);
        this.\u00a4.setServerResponseTimeout(this.\u00a5);
    }

    protected void checkConnection(boolean bl) throws FTPException {
        if (bl && this.\u00a4 == null) {
            throw new SSHFTPException("The SFTP client has not yet connected to the server.  The requested action cannot be performed until after a connection has been established.");
        }
        if (!bl && this.\u00a4 != null) {
            throw new SSHFTPException("The SFTP client has already been connected to the server.  The requested action must be performed before a connection is established.");
        }
    }

    public void setProgressMonitor(FTPProgressMonitor fTPProgressMonitor, long l2) {
        this.\u00c0.A(fTPProgressMonitor);
        this.\u00c0.A(l2);
    }

    public void setProgressMonitor(FTPProgressMonitor fTPProgressMonitor) {
        this.\u00c0.A(fTPProgressMonitor);
    }

    public long getMonitorInterval() {
        return this.\u00c0.C();
    }

    public long size(String string) throws IOException, FTPException {
        this.checkConnection(true);
        return this.\u00a4.stat(string).getSize().longValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(String string, String string2) throws IOException, FTPException {
        this.checkConnection(true);
        FTPTransferType fTPTransferType = this.t;
        this.D(string);
        try {
            this.\u00a4.put(string, string2, (FileTransferProgress)this.\u00c0, false, this.r);
        }
        finally {
            this.t = fTPTransferType;
            this.r = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(String string, String string2, boolean bl) throws IOException, FTPException {
        this.checkConnection(true);
        FTPTransferType fTPTransferType = this.t;
        this.D(string);
        try {
            this.\u00a4.put(string, string2, (FileTransferProgress)this.\u00c0, bl, this.r);
        }
        finally {
            this.t = fTPTransferType;
            this.r = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(InputStream inputStream, String string) throws IOException, FTPException {
        this.checkConnection(true);
        FTPTransferType fTPTransferType = this.t;
        this.D(string);
        try {
            this.\u00a4.put(inputStream, string, (FileTransferProgress)this.\u00c0, false, this.r);
        }
        finally {
            this.t = fTPTransferType;
            this.r = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(InputStream inputStream, String string, boolean bl) throws IOException, FTPException {
        this.checkConnection(true);
        FTPTransferType fTPTransferType = this.t;
        this.D(string);
        try {
            this.\u00a4.put(inputStream, string, (FileTransferProgress)this.\u00c0, bl, this.r);
        }
        finally {
            this.t = fTPTransferType;
            this.r = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(byte[] byArray, String string) throws IOException, FTPException {
        this.checkConnection(true);
        FTPTransferType fTPTransferType = this.t;
        this.D(string);
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            this.\u00a4.put(byteArrayInputStream, string, (FileTransferProgress)this.\u00c0, false, this.r);
            ((InputStream)byteArrayInputStream).close();
        }
        finally {
            this.t = fTPTransferType;
            this.r = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(byte[] byArray, String string, boolean bl) throws IOException, FTPException {
        this.checkConnection(true);
        FTPTransferType fTPTransferType = this.t;
        this.D(string);
        ByteArrayInputStream byteArrayInputStream = null;
        try {
            byteArrayInputStream = new ByteArrayInputStream(byArray);
            this.\u00a4.put(byteArrayInputStream, string, (FileTransferProgress)this.\u00c0, bl, this.r);
            Object var7_6 = null;
            this.t = fTPTransferType;
            this.r = false;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.t = fTPTransferType;
            this.r = false;
            ((InputStream)byteArrayInputStream).close();
            throw throwable;
        }
        ((InputStream)byteArrayInputStream).close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void get(String string, String string2) throws IOException, FTPException {
        this.checkConnection(true);
        FTPTransferType fTPTransferType = this.t;
        this.D(string2);
        try {
            this.\u00a4.get(string2, string, (FileTransferProgress)this.\u00c0, this.r);
        }
        finally {
            this.t = fTPTransferType;
            this.r = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void get(OutputStream outputStream, String string) throws IOException, FTPException {
        this.checkConnection(true);
        FTPTransferType fTPTransferType = this.t;
        this.D(string);
        try {
            this.\u00a4.get(string, outputStream, (FileTransferProgress)this.\u00c0, 0L);
        }
        finally {
            this.t = fTPTransferType;
            this.r = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] get(String string) throws IOException, FTPException {
        this.checkConnection(true);
        FTPTransferType fTPTransferType = this.t;
        this.D(string);
        try {
            long l2 = this.size(string);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream((int)l2);
            this.\u00a4.get(string, byteArrayOutputStream, (FileTransferProgress)this.\u00c0, 0L);
            byte[] byArray = byteArrayOutputStream.toByteArray();
            return byArray;
        }
        finally {
            this.t = fTPTransferType;
            this.r = false;
        }
    }

    public FTPFile[] dirDetails(String string) throws IOException, FTPException, ParseException {
        this.checkConnection(true);
        List list = this.\u00a4.ls(string);
        FTPFile[] fTPFileArray = new FTPFile[list.size()];
        for (int i2 = 0; i2 < list.size(); ++i2) {
            SftpFile sftpFile = (SftpFile)list.get(i2);
            FileAttributes fileAttributes = sftpFile.getAttributes();
            Date date = new Date(fileAttributes.getModifiedTime().longValue() * 1000L);
            FTPFile fTPFile = new FTPFile(sftpFile.getLongname(), sftpFile.getFilename(), fileAttributes.getSize().longValue(), fileAttributes.isDirectory(), date);
            fTPFile.setOwner(fileAttributes.getUID().toString());
            fTPFile.setGroup(fileAttributes.getGID().toString());
            fTPFileArray[i2] = fTPFile;
        }
        return fTPFileArray;
    }

    public String[] dir() throws IOException, FTPException {
        return this.dir(".");
    }

    public String[] dir(String string) throws IOException, FTPException {
        return this.dir(string, false);
    }

    public String[] dir(String string, boolean bl) throws IOException, FTPException {
        this.checkConnection(true);
        List list = this.\u00a4.ls(string);
        String[] stringArray = new String[list.size()];
        for (int i2 = 0; i2 < list.size(); ++i2) {
            SftpFile sftpFile = (SftpFile)list.get(i2);
            stringArray[i2] = bl ? sftpFile.getLongname() : sftpFile.getFilename();
        }
        return stringArray;
    }

    public void delete(String string) throws IOException, FTPException {
        this.checkConnection(true);
        this.\u00a4.rm(string);
    }

    public void rename(String string, String string2) throws IOException, FTPException {
        this.checkConnection(true);
        this.\u00a4.rename(string, string2);
    }

    public boolean exists(String string) throws IOException, FTPException {
        this.checkConnection(true);
        try {
            this.\u00a4.stat(string);
            return true;
        }
        catch (FTPException fTPException) {
            if (fTPException.getReplyCode() == 2) {
                return false;
            }
            throw fTPException;
        }
    }

    public void rmdir(String string) throws IOException, FTPException {
        this.checkConnection(true);
        FileAttributes fileAttributes = this.\u00a4.stat(string);
        if (!fileAttributes.isDirectory()) {
            throw new FTPException(string + " is not a directory.");
        }
        List list = this.\u00a4.ls(string);
        for (int i2 = 0; i2 < list.size(); ++i2) {
            SftpFile sftpFile = (SftpFile)list.get(i2);
            if (sftpFile.getFilename().equals(".") || sftpFile.getFilename().equals("..")) continue;
            throw new FTPException("Directory " + string + " is not empty");
        }
        this.\u00a4.rm(string);
    }

    public void mkdir(String string) throws IOException, FTPException {
        this.checkConnection(true);
        this.\u00a4.mkdir(string);
    }

    public void changeMode(int n2, String string) throws IOException, FTPException {
        this.checkConnection(true);
        this.\u00a4.chmod(n2, string);
    }

    public void changeGroup(int n2, String string) throws IOException, FTPException {
        this.checkConnection(true);
        this.\u00a4.chgrp(n2, string);
    }

    public void changeOwner(int n2, String string) throws IOException, FTPException {
        this.checkConnection(true);
        this.\u00a4.chown(n2, string);
    }

    public void setUmask(String string) throws FTPException {
        this.checkConnection(true);
        this.\u00a4.setUmask(string);
    }

    public String getUmask() throws FTPException {
        this.checkConnection(true);
        return this.\u00a4.getUmask();
    }

    public void chdir(String string) throws IOException, FTPException {
        this.checkConnection(true);
        this.\u00a4.cd(string);
    }

    public void cdup() throws IOException, FTPException {
        this.checkConnection(true);
        this.\u00a4.cd("..");
    }

    public Date modtime(String string) throws IOException, FTPException {
        this.checkConnection(true);
        FileAttributes fileAttributes = this.\u00a4.stat(string);
        return new Date(fileAttributes.getModifiedTime().longValue() * 1000L);
    }

    public String pwd() throws IOException, FTPException {
        this.checkConnection(true);
        return this.\u00a4.pwd();
    }

    public void mdelete(String string) throws IOException, FTPException, ParseException {
        this.q.deleteFilesCurrentDir(this, new WildcardFilter(string));
    }

    public void mdelete(FileFilter fileFilter) throws IOException, FTPException, ParseException {
        this.q.deleteFilesCurrentDir(this, fileFilter);
    }

    public void mdelete(String string, String string2, boolean bl) throws IOException, FTPException, ParseException {
        this.q.deleteFiles(this, string, new WildcardFilter(string2), bl);
    }

    public void mdelete(String string, FileFilter fileFilter, boolean bl) throws IOException, FTPException, ParseException {
        this.q.deleteFiles(this, string, fileFilter, bl);
    }

    public void rmdir(String string, boolean bl) throws IOException, FTPException, ParseException {
        if (!bl) {
            this.rmdir(string);
        } else {
            this.q.delete(this, string);
        }
    }

    public void mput(String string, String string2) throws IOException, FTPException {
        this.q.putFilesIntoCurrentDir(this, string, new WildcardFilter(string2));
    }

    public void mput(String string, FileFilter fileFilter) throws IOException, FTPException {
        this.q.putFilesIntoCurrentDir(this, string, fileFilter);
    }

    public void mput(String string, String string2, String string3, boolean bl) throws FTPException, IOException {
        this.q.put(this, string, string2, new WildcardFilter(string3), bl);
    }

    public void mput(String string, String string2, FileFilter fileFilter, boolean bl) throws FTPException, IOException {
        this.q.put(this, string, string2, fileFilter, bl);
    }

    public void mget(String string, String string2) throws IOException, FTPException, ParseException {
        this.q.getFilesFromCurrentDir(this, string, new WildcardFilter(string2));
    }

    public void mget(String string, FileFilter fileFilter) throws IOException, FTPException, ParseException {
        this.q.getFilesFromCurrentDir(this, string, fileFilter);
    }

    public void mget(String string, String string2, String string3, boolean bl) throws FTPException, IOException, ParseException {
        this.q.get(this, string, string2, new WildcardFilter(string3), bl);
    }

    public void mget(String string, String string2, FileFilter fileFilter, boolean bl) throws FTPException, IOException, ParseException {
        this.q.get(this, string, string2, fileFilter, bl);
    }

    public int getCountBeforeSleep() {
        return this.q.getCountBeforeSleep();
    }

    public void setCountBeforeSleep(int n2) {
        this.q.setCountBeforeSleep(n2);
    }

    public boolean isSleepEnabled() {
        return this.q.isSleepEnabled();
    }

    public void setSleepEnabled(boolean bl) {
        this.q.setSleepEnabled(bl);
    }

    public int getSleepTime() {
        return this.q.getSleepTime();
    }

    public void setSleepTime(int n2) {
        this.q.setSleepTime(n2);
    }

    public void quit() throws IOException, FTPException {
        this.checkConnection(true);
        this.\u00a4.quit();
        this.\u00a4 = null;
        this.\u00a3.disconnect();
        this.\u00a3 = new SshClient();
    }

    private void D(String string) {
        if (this.z) {
            if (FileTypes.ASCII.matches(string) && this.t.equals(FTPTransferType.BINARY)) {
                this.t = FTPTransferType.ASCII;
                this.x.debug("Autodetect on - changed transfer type to ASCII");
            } else if (FileTypes.BINARY.matches(string) && this.t.equals(FTPTransferType.ASCII)) {
                this.t = FTPTransferType.BINARY;
                this.x.debug("Autodetect on - changed transfer type to binary");
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class ConfigFlags {
        public static int DISABLE_POST_CREATE_CHMOD = 1;
        public static int DISABLE_CHMOD_AFTER_PUT = 1;
    }
}

