/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.j2ssh.io;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class IOUtil {
    public static boolean closeStream(InputStream inputStream) {
        try {
            if (inputStream != null) {
                inputStream.close();
            }
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public static boolean closeStream(OutputStream outputStream) {
        try {
            if (outputStream != null) {
                outputStream.close();
            }
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public static boolean delTree(File file) {
        if (file.isFile()) {
            return file.delete();
        }
        File[] fileArray = file.listFiles();
        for (int i2 = 0; i2 < fileArray.length; ++i2) {
            if (IOUtil.delTree(fileArray[i2])) continue;
            return false;
        }
        return true;
    }

    public static void recurseDeleteDirectory(File file) {
        int n2;
        File[] fileArray = file.listFiles(new FileFilter(){

            public boolean accept(File file) {
                return file.isDirectory();
            }
        });
        if (fileArray == null) {
            return;
        }
        for (n2 = 0; n2 < fileArray.length; ++n2) {
            IOUtil.recurseDeleteDirectory(fileArray[n2]);
            fileArray[n2].delete();
        }
        fileArray = file.listFiles(new FileFilter(){

            public boolean accept(File file) {
                return !file.isDirectory();
            }
        });
        for (n2 = 0; n2 < fileArray.length; ++n2) {
            fileArray[n2].delete();
        }
        file.delete();
    }

    public static void copyFile(File file, File file2) throws IOException {
        if (file.isDirectory()) {
            if (!file2.exists()) {
                file2.mkdir();
            }
            File[] fileArray = file.listFiles();
            for (int i2 = 0; i2 < fileArray.length; ++i2) {
                if (fileArray[i2].getName().equals(".") || fileArray[i2].getName().equals("..")) continue;
                if (fileArray[i2].isDirectory()) {
                    File file3 = new File(file2, fileArray[i2].getName());
                    IOUtil.copyFile(fileArray[i2], file3);
                    continue;
                }
                IOUtil.copyFile(fileArray[i2], file2);
            }
        } else if (file.isFile() && (file2.isDirectory() || file2.isFile())) {
            int n2;
            if (file2.isDirectory()) {
                file2 = new File(file2, file.getName());
            }
            FileInputStream fileInputStream = new FileInputStream(file);
            FileOutputStream fileOutputStream = new FileOutputStream(file2);
            byte[] byArray = new byte[32678];
            while ((n2 = fileInputStream.read(byArray)) > -1) {
                fileOutputStream.write(byArray, 0, n2);
            }
            IOUtil.closeStream(fileInputStream);
            IOUtil.closeStream(fileOutputStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void transfer(InputStream inputStream, OutputStream outputStream) throws IOException {
        try {
            int n2;
            long l2 = 0L;
            byte[] byArray = new byte[65535];
            while ((n2 = inputStream.read(byArray)) > -1) {
                if (n2 <= 0) continue;
                outputStream.write(byArray, 0, n2);
                l2 += (long)n2;
            }
        }
        finally {
            IOUtil.closeStream(inputStream);
            IOUtil.closeStream(outputStream);
        }
    }
}

