/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.j2ssh.transport.publickey;

import com.enterprisedt.net.j2ssh.SshThread;
import com.enterprisedt.net.j2ssh.transport.publickey.InvalidSshKeyException;
import com.enterprisedt.net.j2ssh.transport.publickey.OpenSSHPublicKeyFormat;
import com.enterprisedt.net.j2ssh.transport.publickey.SECSHPublicKeyFormat;
import com.enterprisedt.net.j2ssh.transport.publickey.SshKeyPair;
import com.enterprisedt.net.j2ssh.transport.publickey.SshKeyPairFactory;
import com.enterprisedt.net.j2ssh.transport.publickey.SshPrivateKeyFile;
import com.enterprisedt.net.j2ssh.transport.publickey.SshPublicKeyFile;
import com.enterprisedt.net.j2ssh.transport.publickey.SshPublicKeyFormat;
import com.enterprisedt.net.j2ssh.transport.publickey.SshtoolsPrivateKeyFormat;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Method;

public class SshKeyGenerator {
    private static String B = null;
    private static String E = "dsa";
    private static int H = 1024;
    private static boolean G;
    private static boolean D;
    private static boolean F;
    private static boolean C;
    private static boolean A;

    public void generateKeyPair(String string, int n2, String string2, String string3, String string4) throws IOException {
        System.out.println("****Sshtools.com SSH Key Pair Generator****");
        String string5 = string;
        if (string5.equalsIgnoreCase("DSA")) {
            string5 = "ssh-dss";
        }
        if (string5.equalsIgnoreCase("RSA")) {
            string5 = "ssh-rsa";
        }
        final SshKeyPair sshKeyPair = SshKeyPairFactory.newInstance(string5);
        System.out.println("Generating " + String.valueOf(n2) + " bit " + string5 + " key pair");
        SshThread sshThread = new SshThread(new Runnable(){

            public void run() {
                sshKeyPair.generate(H);
            }
        }, "Key generator", true);
        sshThread.start();
        while (sshThread.isAlive()) {
            System.out.print(".");
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        System.out.println();
        System.out.println("Creating Public Key file " + string2 + ".pub");
        SshPublicKeyFile sshPublicKeyFile = SshPublicKeyFile.create(sshKeyPair.getPublicKey(), new SECSHPublicKeyFormat(string3, String.valueOf(n2) + "-bit " + string));
        FileOutputStream fileOutputStream = new FileOutputStream(string2 + ".pub");
        fileOutputStream.write(sshPublicKeyFile.getBytes());
        fileOutputStream.close();
        System.out.println("Generating Private Key file " + string2);
        if (string4 == null) {
            string4 = SshKeyGenerator.A(true);
        }
        SshPrivateKeyFile sshPrivateKeyFile = SshPrivateKeyFile.create(sshKeyPair.getPrivateKey(), string4, new SshtoolsPrivateKeyFormat(string3, String.valueOf(n2) + "-bit " + string));
        fileOutputStream = new FileOutputStream(string2);
        fileOutputStream.write(sshPrivateKeyFile.getBytes());
        fileOutputStream.close();
    }

    public static void main(String[] stringArray) {
        block14: {
            try {
                SshKeyGenerator.processCommandLine(stringArray);
                if (G) {
                    Class<?> clazz = Class.forName("com.enterprisedt.net.j2ssh.keygen.Main");
                    Method method = clazz.getMethod("main", stringArray.getClass());
                    method.invoke(null, new Object[]{new String[0]});
                    break block14;
                }
                File file = new File(B);
                if (B == null) {
                    System.err.print("You must supply a valid file to convert!");
                    System.exit(1);
                }
                if (F || C) {
                    if (!file.exists()) {
                        System.err.print("The file " + file.getAbsolutePath() + " does not exist!");
                        System.exit(1);
                    }
                    try {
                        if (F) {
                            System.out.print(SshKeyGenerator.convertPublicKeyFile(file, new OpenSSHPublicKeyFormat()));
                        } else {
                            System.out.print(SshKeyGenerator.convertPublicKeyFile(file, new SECSHPublicKeyFormat()));
                        }
                    }
                    catch (InvalidSshKeyException invalidSshKeyException) {
                        System.err.println("The key format is invalid!");
                    }
                    catch (IOException iOException) {
                        System.err.println("An error occurs whilst reading the file " + file.getAbsolutePath());
                    }
                    System.exit(0);
                }
                if (A) {
                    if (!file.exists()) {
                        System.err.print("The file " + file.getAbsolutePath() + " does not exist!");
                        System.exit(1);
                    }
                    SshKeyGenerator.A(file);
                } else {
                    SshKeyGenerator sshKeyGenerator = new SshKeyGenerator();
                    String string = System.getProperty("user.name");
                    sshKeyGenerator.generateKeyPair(E, H, B, string, null);
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    public static void processCommandLine(String[] stringArray) {
        if (stringArray.length > 0) {
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                if (stringArray[i2].equalsIgnoreCase("-b")) {
                    H = Integer.parseInt(stringArray[++i2]);
                    continue;
                }
                if (stringArray[i2].equalsIgnoreCase("-t")) {
                    E = stringArray[++i2];
                    continue;
                }
                if (stringArray[i2].equalsIgnoreCase("-p")) {
                    A = true;
                    continue;
                }
                if (stringArray[i2].equalsIgnoreCase("-g") && D) {
                    G = true;
                    continue;
                }
                if (stringArray[i2].equalsIgnoreCase("-i")) {
                    F = true;
                    continue;
                }
                if (stringArray[i2].equalsIgnoreCase("-e")) {
                    C = true;
                    continue;
                }
                if (stringArray[i2].startsWith("-")) continue;
                if (B != null) {
                    SshKeyGenerator.A();
                    System.exit(1);
                }
                B = stringArray[i2];
            }
        }
        if (!G && B == null) {
            SshKeyGenerator.A();
            System.exit(0);
        }
    }

    private static void A(File file) {
        System.out.println("Opening Private Key file " + file.getAbsolutePath());
        try {
            System.out.println("Opening Private Key file " + file.getAbsolutePath());
            String string = SshKeyGenerator.A(false);
            String string2 = SshKeyGenerator.A(true);
            SshKeyGenerator.changePassphrase(file, string, string2);
        }
        catch (InvalidSshKeyException invalidSshKeyException) {
            System.err.println("The key format is invalid!");
        }
        catch (IOException iOException) {
            System.err.println("An error occurs whilst reading the file " + file.getAbsolutePath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void changePassphrase(File file, String string, String string2) throws IOException, InvalidSshKeyException {
        SshPrivateKeyFile sshPrivateKeyFile = SshPrivateKeyFile.parse(file);
        System.out.println("Saving Private Key file with new passphrase");
        sshPrivateKeyFile.changePassphrase(string, string2);
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file);
            fileOutputStream.write(sshPrivateKeyFile.getBytes());
        }
        finally {
            if (fileOutputStream != null) {
                fileOutputStream.close();
            }
        }
    }

    public static String convertPublicKeyFile(File file, SshPublicKeyFormat sshPublicKeyFormat) throws InvalidSshKeyException, IOException {
        SshPublicKeyFile sshPublicKeyFile = SshPublicKeyFile.parse(file);
        sshPublicKeyFile.setFormat(sshPublicKeyFormat);
        return sshPublicKeyFile.toString();
    }

    private static void A() {
        System.out.println("Usage: SshKeyGenerator [options] filename");
        System.out.println("Options:");
        System.out.println("-b bits        Number of bits in the key to create.");
        System.out.println("-e             Convert OpenSSH to IETF SECSH key file.");
        System.out.println("-i             Convert IETF SECSH to OpenSSH key file.");
        System.out.println("-t type        The type of key to create.");
        System.out.println("-p             Change the passphrase of the private key file.");
        if (D) {
            System.out.println("-g \t\tUse GUI to create key");
        }
    }

    private static String A(boolean bl) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
        String string = "";
        String string2 = "";
        while (true) {
            System.out.print("Enter passphrase: ");
            string = bufferedReader.readLine();
            if (!bl) break;
            System.out.print("Confirm passphrase: ");
            string2 = bufferedReader.readLine();
            if (string.equals(string2)) {
                if (string.trim().length() != 0) break;
                System.out.print("You supplied an empty passphrase, are you sure? [Yes|No]: ");
                string2 = bufferedReader.readLine();
                if (!string2.equalsIgnoreCase("YES")) continue;
                break;
            }
            System.out.println("The passphrases supplied were not indentical! Try again");
        }
        return string;
    }

    static {
        F = false;
        C = false;
        A = false;
        try {
            Class.forName("com.enterprisedt.net.j2ssh.keygen.Main");
            D = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }
}

