/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.j2ssh.transport.publickey.dsa;

import com.enterprisedt.net.j2ssh.io.ByteArrayReader;
import com.enterprisedt.net.j2ssh.io.ByteArrayWriter;
import com.enterprisedt.net.j2ssh.transport.publickey.InvalidSshKeyException;
import com.enterprisedt.net.j2ssh.transport.publickey.InvalidSshKeySignatureException;
import com.enterprisedt.net.j2ssh.transport.publickey.SshPublicKey;
import com.enterprisedt.net.j2ssh.util.SimpleASNWriter;
import com.enterprisedt.util.debug.Logger;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Signature;
import java.security.SignatureException;
import java.security.interfaces.DSAPublicKey;
import java.security.spec.DSAPublicKeySpec;

public class SshDssPublicKey
extends SshPublicKey {
    private static Logger B = Logger.getLogger(class$com$enterprisedt$net$j2ssh$transport$publickey$dsa$SshDssPublicKey == null ? (class$com$enterprisedt$net$j2ssh$transport$publickey$dsa$SshDssPublicKey = SshDssPublicKey.class$("com.enterprisedt.net.j2ssh.transport.publickey.dsa.SshDssPublicKey")) : class$com$enterprisedt$net$j2ssh$transport$publickey$dsa$SshDssPublicKey);
    private DSAPublicKey A;
    static /* synthetic */ Class class$com$enterprisedt$net$j2ssh$transport$publickey$dsa$SshDssPublicKey;

    public SshDssPublicKey(DSAPublicKey dSAPublicKey) {
        this.A = dSAPublicKey;
    }

    public SshDssPublicKey(byte[] byArray) throws InvalidSshKeyException {
        try {
            ByteArrayReader byteArrayReader = new ByteArrayReader(byArray);
            String string = byteArrayReader.readString();
            if (!string.equals(this.getAlgorithmName())) {
                throw new InvalidSshKeyException(string);
            }
            BigInteger bigInteger = byteArrayReader.readBigInteger();
            BigInteger bigInteger2 = byteArrayReader.readBigInteger();
            BigInteger bigInteger3 = byteArrayReader.readBigInteger();
            BigInteger bigInteger4 = byteArrayReader.readBigInteger();
            DSAPublicKeySpec dSAPublicKeySpec = new DSAPublicKeySpec(bigInteger4, bigInteger, bigInteger2, bigInteger3);
            KeyFactory keyFactory = KeyFactory.getInstance("DSA");
            this.A = (DSAPublicKey)keyFactory.generatePublic(dSAPublicKeySpec);
        }
        catch (Exception exception) {
            B.error("SshDssPublicKey", exception);
            throw new InvalidSshKeyException(exception);
        }
    }

    public String getAlgorithmName() {
        return "ssh-dss";
    }

    public int getBitLength() {
        return this.A.getY().bitLength();
    }

    public byte[] getEncoded() {
        try {
            ByteArrayWriter byteArrayWriter = new ByteArrayWriter();
            byteArrayWriter.writeString(this.getAlgorithmName());
            byteArrayWriter.writeBigInteger(this.A.getParams().getP());
            byteArrayWriter.writeBigInteger(this.A.getParams().getQ());
            byteArrayWriter.writeBigInteger(this.A.getParams().getG());
            byteArrayWriter.writeBigInteger(this.A.getY());
            return byteArrayWriter.toByteArray();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public boolean verifySignature(byte[] byArray, byte[] byArray2) throws InvalidSshKeySignatureException {
        try {
            Object object;
            Object object2;
            Object object3;
            Closeable closeable;
            if (byArray.length != 40) {
                closeable = new ByteArrayReader(byArray);
                object3 = ((ByteArrayReader)closeable).readBinaryString();
                object2 = new String((byte[])object3);
                B.debug("Header is " + (String)object2);
                if (!((String)object2).equals("ssh-dss")) {
                    throw new InvalidSshKeySignatureException((String)object2);
                }
                byArray = ((ByteArrayReader)closeable).readBinaryString();
            }
            closeable = new ByteArrayOutputStream();
            object3 = new ByteArrayOutputStream();
            object2 = new SimpleASNWriter();
            ((SimpleASNWriter)object2).writeByte(2);
            if ((byArray[0] & 0x80) == 128 && byArray[0] != 0) {
                ((ByteArrayOutputStream)closeable).write(0);
                ((ByteArrayOutputStream)closeable).write(byArray, 0, 20);
            } else {
                ((ByteArrayOutputStream)closeable).write(byArray, 0, 20);
            }
            ((SimpleASNWriter)object2).writeData(((ByteArrayOutputStream)closeable).toByteArray());
            ((SimpleASNWriter)object2).writeByte(2);
            if ((byArray[20] & 0x80) == 128 && byArray[20] != 0) {
                ((ByteArrayOutputStream)object3).write(0);
                ((ByteArrayOutputStream)object3).write(byArray, 20, 20);
            } else {
                ((ByteArrayOutputStream)object3).write(byArray, 20, 20);
            }
            ((SimpleASNWriter)object2).writeData(((ByteArrayOutputStream)object3).toByteArray());
            SimpleASNWriter simpleASNWriter = new SimpleASNWriter();
            simpleASNWriter.writeByte(48);
            simpleASNWriter.writeData(((SimpleASNWriter)object2).toByteArray());
            byte[] byArray3 = simpleASNWriter.toByteArray();
            if (B.isDebugEnabled()) {
                int n2;
                B.debug("Verifying host key signature");
                B.debug("Signature length is " + String.valueOf(byArray.length));
                object = "";
                for (n2 = 0; n2 < byArray.length; ++n2) {
                    object = (String)object + Integer.toHexString(byArray[n2] & 0xFF) + " ";
                }
                B.debug("SSH: " + (String)object);
                object = "";
                for (n2 = 0; n2 < byArray3.length; ++n2) {
                    object = (String)object + Integer.toHexString(byArray3[n2] & 0xFF) + " ";
                }
                B.debug("Encoded: " + (String)object);
            }
            object = Signature.getInstance("SHA1withDSA", "CryptixEDT");
            ((Signature)object).initVerify(this.A);
            ((Signature)object).update(byArray2);
            return ((Signature)object).verify(byArray3);
        }
        catch (NoSuchProviderException noSuchProviderException) {
            B.error("verifySignature", noSuchProviderException);
            throw new InvalidSshKeySignatureException();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            B.error("verifySignature", noSuchAlgorithmException);
            throw new InvalidSshKeySignatureException(noSuchAlgorithmException);
        }
        catch (InvalidKeyException invalidKeyException) {
            B.error("verifySignature", invalidKeyException);
            throw new InvalidSshKeySignatureException(invalidKeyException);
        }
        catch (IOException iOException) {
            B.error("verifySignature", iOException);
            throw new InvalidSshKeySignatureException(iOException);
        }
        catch (SignatureException signatureException) {
            B.error("verifySignature", signatureException);
            throw new InvalidSshKeySignatureException(signatureException);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

