/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.j2ssh.transport.publickey.rsa;

import com.enterprisedt.net.j2ssh.io.ByteArrayReader;
import com.enterprisedt.net.j2ssh.io.ByteArrayWriter;
import com.enterprisedt.net.j2ssh.transport.publickey.InvalidSshKeyException;
import com.enterprisedt.net.j2ssh.transport.publickey.SshPrivateKey;
import com.enterprisedt.net.j2ssh.transport.publickey.SshPublicKey;
import com.enterprisedt.net.j2ssh.transport.publickey.rsa.SshRsaPublicKey;
import com.enterprisedt.util.debug.Logger;
import java.io.IOException;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.Signature;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.RSAPrivateKeySpec;
import java.security.spec.RSAPublicKeySpec;

public class SshRsaPrivateKey
extends SshPrivateKey {
    private static Logger E = Logger.getLogger(class$com$enterprisedt$net$j2ssh$transport$publickey$rsa$SshRsaPrivateKey == null ? (class$com$enterprisedt$net$j2ssh$transport$publickey$rsa$SshRsaPrivateKey = SshRsaPrivateKey.class$("com.enterprisedt.net.j2ssh.transport.publickey.rsa.SshRsaPrivateKey")) : class$com$enterprisedt$net$j2ssh$transport$publickey$rsa$SshRsaPrivateKey);
    RSAPrivateKey C;
    RSAPublicKey D;
    static /* synthetic */ Class class$com$enterprisedt$net$j2ssh$transport$publickey$rsa$SshRsaPrivateKey;

    public SshRsaPrivateKey(RSAPrivateKey rSAPrivateKey, RSAPublicKey rSAPublicKey) {
        this.C = rSAPrivateKey;
        this.D = rSAPublicKey;
    }

    public SshRsaPrivateKey(byte[] byArray) throws InvalidSshKeyException {
        try {
            ByteArrayReader byteArrayReader = new ByteArrayReader(byArray);
            String string = byteArrayReader.readString();
            if (!string.equals(this.getAlgorithmName())) {
                String string2 = "Header '" + string + "' does not match algorithm name '" + this.getAlgorithmName() + "'";
                E.error(string2);
                throw new InvalidSshKeyException(string2);
            }
            BigInteger bigInteger = byteArrayReader.readBigInteger();
            BigInteger bigInteger2 = byteArrayReader.readBigInteger();
            BigInteger bigInteger3 = byteArrayReader.readBigInteger();
            RSAPrivateKeySpec rSAPrivateKeySpec = new RSAPrivateKeySpec(bigInteger2, bigInteger3);
            RSAPublicKeySpec rSAPublicKeySpec = new RSAPublicKeySpec(bigInteger2, bigInteger);
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            this.C = (RSAPrivateKey)keyFactory.generatePrivate(rSAPrivateKeySpec);
            this.D = (RSAPublicKey)keyFactory.generatePublic(rSAPublicKeySpec);
        }
        catch (InvalidSshKeyException invalidSshKeyException) {
            throw invalidSshKeyException;
        }
        catch (Exception exception) {
            String string = "Failed to create private key";
            E.error(string, exception);
            throw new InvalidSshKeyException(string);
        }
    }

    public boolean equals(Object object) {
        if (object instanceof SshRsaPrivateKey) {
            return this.C.equals(((SshRsaPrivateKey)object).C);
        }
        return false;
    }

    public int hashCode() {
        return this.C.hashCode();
    }

    public String getAlgorithmName() {
        return "ssh-rsa";
    }

    public int getBitLength() {
        return this.C.getModulus().bitLength();
    }

    public byte[] getEncoded() {
        try {
            ByteArrayWriter byteArrayWriter = new ByteArrayWriter();
            byteArrayWriter.write(this.getPublicKey().getEncoded());
            byteArrayWriter.writeBigInteger(this.C.getPrivateExponent());
            return byteArrayWriter.toByteArray();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public SshPublicKey getPublicKey() {
        return new SshRsaPublicKey(this.D);
    }

    public byte[] generateSignature(byte[] byArray) {
        try {
            Signature signature = Signature.getInstance("SHA1withRSA", "CryptixEDT");
            signature.initSign(this.C);
            signature.update(byArray);
            ByteArrayWriter byteArrayWriter = new ByteArrayWriter();
            byteArrayWriter.writeString(this.getAlgorithmName());
            byteArrayWriter.writeBinaryString(signature.sign());
            return byteArrayWriter.toByteArray();
        }
        catch (Exception exception) {
            return null;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

