/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.puretls.cert;

import com.enterprisedt.cryptix.util.mime.Base64OutputStream;
import com.enterprisedt.net.puretls.LoadProviders;
import com.enterprisedt.net.puretls.cert.C;
import com.enterprisedt.net.puretls.cert.DERUtils;
import com.enterprisedt.net.puretls.cert.E;
import com.enterprisedt.net.puretls.cert.EAYDSAPrivateKey;
import com.enterprisedt.net.puretls.cert.X509DSAPublicKey;
import com.enterprisedt.net.puretls.cert.X509Name;
import com.enterprisedt.net.puretls.crypto.EAYEncryptedPrivateKey;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.interfaces.DSAKeyPairGenerator;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.DSAPublicKey;
import java.util.Vector;
import xjava.security.interfaces.CryptixRSAPrivateKey;
import xjava.security.interfaces.CryptixRSAPublicKey;

public class CertRequest {
    public static KeyPair generateKey(String string, int n2, String string2, BufferedWriter bufferedWriter, boolean bl) throws NoSuchAlgorithmException, NoSuchProviderException, IOException {
        Object object;
        KeyPairGenerator keyPairGenerator;
        if (string.equals("DSA")) {
            keyPairGenerator = KeyPairGenerator.getInstance(string);
            object = (DSAKeyPairGenerator)((Object)keyPairGenerator);
            object.initialize(n2, bl, new SecureRandom());
        } else {
            keyPairGenerator = KeyPairGenerator.getInstance(string, "CryptixEDT");
            keyPairGenerator.initialize(n2);
        }
        object = keyPairGenerator.generateKeyPair();
        PrivateKey privateKey = string.equals("DSA") ? new EAYDSAPrivateKey((DSAPrivateKey)((KeyPair)object).getPrivate()) : new E((CryptixRSAPrivateKey)((KeyPair)object).getPrivate());
        EAYEncryptedPrivateKey.writePrivateKey(privateKey, string2.getBytes(), bufferedWriter);
        return object;
    }

    public static byte[] makeSPKACRequest(KeyPair keyPair) throws IOException {
        byte[] byArray;
        Object object;
        String string;
        byte[] byArray2;
        PrivateKey privateKey = keyPair.getPrivate();
        PublicKey publicKey = keyPair.getPublic();
        String string2 = privateKey.getAlgorithm();
        byte[] byArray3 = new byte[]{48, 11, 6, 7, 42, -122, 72, -50, 56, 4, 3, 5, 0};
        byte[] byArray4 = new byte[]{48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 5, 5, 0};
        if (string2.equals("DSA")) {
            byArray2 = byArray3;
            string = "DSA";
            publicKey = new X509DSAPublicKey((DSAPublicKey)publicKey);
        } else if (string2.equals("RSA")) {
            byArray2 = byArray4;
            string = "SHA-1/RSA/PKCS#1";
            publicKey = new C((CryptixRSAPublicKey)publicKey);
        } else {
            throw new InternalError("Unknown algorithm " + string2);
        }
        byte[] byArray5 = publicKey.getEncoded();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byteArrayOutputStream.write(byArray5);
        DERUtils.encodeIA5String("Challenge", byteArrayOutputStream);
        byte[] byArray6 = byteArrayOutputStream.toByteArray();
        byteArrayOutputStream.reset();
        DERUtils.encodeSequence(byArray6, (OutputStream)byteArrayOutputStream);
        byte[] byArray7 = byteArrayOutputStream.toByteArray();
        try {
            object = Signature.getInstance(string, "CryptixEDT");
            ((Signature)object).initSign(privateKey);
            ((Signature)object).update(byArray7);
            byArray = ((Signature)object).sign();
        }
        catch (Exception exception) {
            throw new InternalError(exception.toString());
        }
        byteArrayOutputStream.reset();
        byteArrayOutputStream.write(byArray7);
        byteArrayOutputStream.write(byArray2);
        if (string2.equals("RSA")) {
            byArray = CertRequest.fitSignature(byArray, publicKey);
        }
        DERUtils.encodeBitString(byArray, byteArrayOutputStream);
        object = byteArrayOutputStream.toByteArray();
        byteArrayOutputStream.reset();
        DERUtils.encodeSequence((byte[])object, (OutputStream)byteArrayOutputStream);
        byte[] byArray8 = byteArrayOutputStream.toByteArray();
        return byArray8;
    }

    public static byte[] makePKCS10Request(KeyPair keyPair, X509Name x509Name) throws IOException {
        byte[] byArray;
        Object object;
        String string;
        byte[] byArray2;
        PrivateKey privateKey = keyPair.getPrivate();
        PublicKey publicKey = keyPair.getPublic();
        String string2 = privateKey.getAlgorithm();
        byte[] byArray3 = new byte[]{48, 11, 6, 7, 42, -122, 72, -50, 56, 4, 3, 5, 0};
        byte[] byArray4 = new byte[]{48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 5, 5, 0};
        if (string2.equals("DSA")) {
            byArray2 = byArray3;
            string = "DSA";
            publicKey = new X509DSAPublicKey((DSAPublicKey)publicKey);
        } else if (string2.equals("RSA")) {
            byArray2 = byArray4;
            string = "SHA-1/RSA/PKCS#1";
            publicKey = new C((CryptixRSAPublicKey)publicKey);
        } else {
            throw new InternalError("Unknown algorithm " + string2);
        }
        byte[] byArray5 = publicKey.getEncoded();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DERUtils.encodeInteger(new BigInteger("0"), byteArrayOutputStream);
        byteArrayOutputStream.write(x509Name.getNameDER());
        byteArrayOutputStream.write(byArray5);
        byte[] byArray6 = byteArrayOutputStream.toByteArray();
        byteArrayOutputStream.reset();
        DERUtils.encodeSequence(byArray6, (OutputStream)byteArrayOutputStream);
        byte[] byArray7 = byteArrayOutputStream.toByteArray();
        try {
            object = Signature.getInstance(string, "CryptixEDT");
            ((Signature)object).initSign(privateKey);
            ((Signature)object).update(byArray7);
            byArray = ((Signature)object).sign();
        }
        catch (Exception exception) {
            throw new InternalError(exception.toString());
        }
        byteArrayOutputStream.reset();
        byteArrayOutputStream.write(byArray7);
        byteArrayOutputStream.write(byArray2);
        if (string2.equals("RSA")) {
            byArray = CertRequest.fitSignature(byArray, publicKey);
        }
        DERUtils.encodeBitString(byArray, byteArrayOutputStream);
        object = byteArrayOutputStream.toByteArray();
        byteArrayOutputStream.reset();
        DERUtils.encodeSequence((byte[])object, (OutputStream)byteArrayOutputStream);
        byte[] byArray8 = byteArrayOutputStream.toByteArray();
        return byArray8;
    }

    public static byte[] makeSelfSignedCert(KeyPair keyPair, X509Name x509Name, int n2) throws IOException {
        byte[] byArray;
        Object object;
        String string;
        byte[] byArray2;
        PrivateKey privateKey = keyPair.getPrivate();
        PublicKey publicKey = keyPair.getPublic();
        String string2 = privateKey.getAlgorithm();
        byte[] byArray3 = new byte[]{48, 11, 6, 7, 42, -122, 72, -50, 56, 4, 3, 5, 0};
        byte[] byArray4 = new byte[]{48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 5, 5, 0};
        if (string2.equals("DSA")) {
            byArray2 = byArray3;
            string = "DSA";
            publicKey = new X509DSAPublicKey((DSAPublicKey)publicKey);
        } else if (string2.equals("RSA")) {
            byArray2 = byArray4;
            string = "SHA-1/RSA/PKCS#1";
            publicKey = new C((CryptixRSAPublicKey)publicKey);
        } else {
            throw new InternalError("Unknown algorithm " + string2);
        }
        byte[] byArray5 = publicKey.getEncoded();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DERUtils.encodeInteger(new BigInteger("0"), byteArrayOutputStream);
        byteArrayOutputStream.write(byArray2);
        byteArrayOutputStream.write(x509Name.getNameDER());
        ByteArrayOutputStream byteArrayOutputStream2 = new ByteArrayOutputStream();
        long l2 = System.currentTimeMillis();
        long l3 = n2;
        long l4 = l2 + l3 * 1000L;
        DERUtils.encodeUTCTime(l2, byteArrayOutputStream2);
        DERUtils.encodeUTCTime(l4, byteArrayOutputStream2);
        DERUtils.encodeSequence(byteArrayOutputStream2, (OutputStream)byteArrayOutputStream);
        byteArrayOutputStream.write(x509Name.getNameDER());
        byteArrayOutputStream.write(byArray5);
        byte[] byArray6 = byteArrayOutputStream.toByteArray();
        byteArrayOutputStream.reset();
        DERUtils.encodeSequence(byArray6, (OutputStream)byteArrayOutputStream);
        byte[] byArray7 = byteArrayOutputStream.toByteArray();
        try {
            object = Signature.getInstance(string, "CryptixEDT");
            ((Signature)object).initSign(privateKey);
            ((Signature)object).update(byArray7);
            byArray = ((Signature)object).sign();
        }
        catch (Exception exception) {
            throw new InternalError(exception.toString());
        }
        byteArrayOutputStream.reset();
        byteArrayOutputStream.write(byArray7);
        byteArrayOutputStream.write(byArray2);
        if (string2.equals("RSA")) {
            byArray = CertRequest.fitSignature(byArray, publicKey);
        }
        DERUtils.encodeBitString(byArray, byteArrayOutputStream);
        object = byteArrayOutputStream.toByteArray();
        byteArrayOutputStream.reset();
        DERUtils.encodeSequence((byte[])object, (OutputStream)byteArrayOutputStream);
        byte[] byArray8 = byteArrayOutputStream.toByteArray();
        return byArray8;
    }

    public static X509Name makeSimpleDN(Vector vector) {
        Vector vector2 = new Vector();
        for (int i2 = 0; i2 < vector.size(); ++i2) {
            String[] stringArray = (String[])vector.elementAt(i2);
            Vector<String[]> vector3 = new Vector<String[]>();
            String[] stringArray2 = new String[]{new String(stringArray[0]), new String(stringArray[1])};
            vector3.addElement(stringArray2);
            vector2.addElement(vector3);
        }
        return new X509Name(vector2);
    }

    protected static byte[] fitSignature(byte[] byArray, PublicKey publicKey) {
        CryptixRSAPublicKey cryptixRSAPublicKey = (CryptixRSAPublicKey)publicKey;
        int n2 = cryptixRSAPublicKey.getModulus().bitLength();
        int n3 = n2 / 8;
        if (byArray.length == (n3 += n2 % 8 > 0 ? 1 : 0)) {
            return byArray;
        }
        byte[] byArray2 = new byte[n3];
        if (byArray.length < n3) {
            int n4;
            for (n4 = 0; n4 < n3 - byArray.length; ++n4) {
                byArray2[n4] = 0;
            }
            System.arraycopy(byArray, 0, byArray2, n4, byArray.length);
        } else {
            int n5;
            for (n5 = 0; n5 < byArray.length - n3; ++n5) {
                if (byArray[n5] == 0) continue;
                throw new InternalError("RSA signature error");
            }
            System.arraycopy(byArray, n5, byArray2, 0, n3);
        }
        return byArray2;
    }

    private static X509Name A(String string) {
        Vector<String[]> vector = new Vector<String[]>();
        String[] stringArray = new String[2];
        String[] stringArray2 = new String[2];
        String[] stringArray3 = new String[2];
        String[] stringArray4 = new String[2];
        stringArray[0] = "C";
        stringArray[1] = "US";
        stringArray2[0] = "O";
        stringArray2[1] = "Snake Oil, Inc.";
        stringArray3[0] = "OU";
        stringArray3[1] = "Test";
        stringArray4[0] = "CN";
        stringArray4[1] = string;
        vector.addElement(stringArray);
        vector.addElement(stringArray2);
        vector.addElement(stringArray3);
        vector.addElement(stringArray4);
        return CertRequest.makeSimpleDN(vector);
    }

    public static void main(String[] stringArray) throws IOException, Exception {
        String string;
        byte[] byArray;
        String string2 = stringArray[0];
        String string3 = null;
        int n2 = 0;
        String string4 = stringArray.length >= 2 ? stringArray[1] : "DSA";
        if (stringArray.length >= 3) {
            if (stringArray[2].equals("SPKAC")) {
                n2 = 0;
            } else if (stringArray[2].equals("PKCS10")) {
                n2 = 1;
            } else if (stringArray[2].equals("X509")) {
                n2 = 2;
            } else {
                throw new InternalError("Unknown type " + stringArray[2]);
            }
        }
        if (n2 == 1 || n2 == 2) {
            if (stringArray.length != 4) {
                throw new InternalError("Must supply common name for type" + n2);
            }
            string3 = stringArray[3];
        }
        int n3 = 1024;
        InputStreamReader inputStreamReader = new InputStreamReader(System.in);
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        String string5 = bufferedReader.readLine();
        FileWriter fileWriter = new FileWriter(string2);
        BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
        KeyPair keyPair = CertRequest.generateKey(string4, n3, string5, bufferedWriter, true);
        switch (n2) {
            case 0: {
                byArray = CertRequest.makeSPKACRequest(keyPair);
                break;
            }
            case 1: {
                byArray = CertRequest.makePKCS10Request(keyPair, CertRequest.A(string3));
                break;
            }
            case 2: {
                byArray = CertRequest.makeSelfSignedCert(keyPair, CertRequest.A(string3), 30000000);
                break;
            }
            default: {
                throw new InternalError("Bad type");
            }
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        Base64OutputStream base64OutputStream = new Base64OutputStream(byteArrayOutputStream);
        base64OutputStream.write(byArray);
        base64OutputStream.flush();
        base64OutputStream.close();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        InputStreamReader inputStreamReader2 = new InputStreamReader(byteArrayInputStream);
        BufferedReader bufferedReader2 = new BufferedReader(inputStreamReader2);
        System.out.println(string5);
        switch (n2) {
            case 1: {
                System.out.println("-----BEGIN CERTIFICATE REQUEST-----");
                break;
            }
            case 2: {
                System.out.println("-----BEGIN CERTIFICATE-----");
            }
        }
        while ((string = bufferedReader2.readLine()) != null) {
            System.out.println(string);
        }
        switch (n2) {
            case 1: {
                System.out.println("-----END CERTIFICATE REQUEST-----");
                break;
            }
            case 2: {
                System.out.println("-----END CERTIFICATE-----");
            }
        }
    }

    static {
        LoadProviders.init();
    }
}

