/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.puretls.cert;

import com.enterprisedt.net.puretls.cert.DERUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;

public class EAYDHParams {
    private BigInteger A;
    private BigInteger B;

    public EAYDHParams(BigInteger bigInteger, BigInteger bigInteger2) {
        this.B = bigInteger2;
        this.A = bigInteger;
    }

    public EAYDHParams(byte[] byArray) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        byte[] byArray2 = DERUtils.decodeSequence(byteArrayInputStream);
        byteArrayInputStream = new ByteArrayInputStream(byArray2);
        this.B = DERUtils.decodeInteger(byteArrayInputStream);
        this.A = DERUtils.decodeInteger(byteArrayInputStream);
    }

    public BigInteger getG() {
        return this.A;
    }

    public BigInteger getP() {
        return this.B;
    }

    public byte[] getEncoded() {
        ByteArrayOutputStream byteArrayOutputStream;
        try {
            byteArrayOutputStream = new ByteArrayOutputStream();
            DERUtils.encodeInteger(this.B, byteArrayOutputStream);
            DERUtils.encodeInteger(this.A, byteArrayOutputStream);
            byte[] byArray = byteArrayOutputStream.toByteArray();
            byteArrayOutputStream.reset();
            DERUtils.encodeSequence(byArray, (OutputStream)byteArrayOutputStream);
        }
        catch (IOException iOException) {
            throw new InternalError(iOException.toString());
        }
        return byteArrayOutputStream.toByteArray();
    }
}

