/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.puretls.crypto;

import com.enterprisedt.net.puretls.cert.EAYDSAPrivateKey;
import com.enterprisedt.net.puretls.cert.EAYRSAPrivateKey;
import com.enterprisedt.net.puretls.crypto.B;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.security.PrivateKey;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.RSAPrivateCrtKey;

public class EAYEncryptedPrivateKey {
    private static final String B = "DSA";
    private static final String A = "RSA";

    public static PrivateKey createPrivateKey(BufferedReader bufferedReader, String string, byte[] byArray) throws IOException, IllegalArgumentException {
        return EAYEncryptedPrivateKey.createPrivateKey(com.enterprisedt.net.puretls.crypto.B.A(bufferedReader, byArray), string, byArray);
    }

    public static PrivateKey createPrivateKey(PrivateKey privateKey, String string) throws IOException, IllegalArgumentException {
        if (string.equals(B)) {
            return new EAYDSAPrivateKey((DSAPrivateKey)privateKey);
        }
        if (string.equals(A)) {
            return new EAYRSAPrivateKey((RSAPrivateCrtKey)privateKey);
        }
        throw new InternalError("Couldn't find key type" + string);
    }

    public static PrivateKey createPrivateKey(byte[] byArray, String string, byte[] byArray2) throws IOException, IllegalArgumentException {
        if (string.equals(B)) {
            return new EAYDSAPrivateKey(byArray);
        }
        if (string.equals(A)) {
            return new EAYRSAPrivateKey(byArray);
        }
        throw new InternalError("Couldn't find key type" + string);
    }

    public static void writePrivateKey(PrivateKey privateKey, byte[] byArray, BufferedWriter bufferedWriter) throws IOException {
        String string = privateKey.getAlgorithm();
        byte[] byArray2 = privateKey.getEncoded();
        String string2 = string + " PRIVATE KEY";
        com.enterprisedt.net.puretls.crypto.B.A(byArray2, byArray, string2, bufferedWriter);
    }
}

