/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.cluster;

import org.apache.jackrabbit.core.NodeId;
import org.apache.jackrabbit.core.cluster.ItemOperation;
import org.apache.jackrabbit.core.cluster.NodeAddedOperation;
import org.apache.jackrabbit.core.cluster.NodeDeletedOperation;
import org.apache.jackrabbit.core.cluster.NodeModifiedOperation;
import org.apache.jackrabbit.core.nodetype.NodeDefId;

abstract class NodeOperation
extends ItemOperation {
    private NodeId id;
    private NodeDefId definitionId;

    protected NodeOperation(int operationType) {
        super(operationType);
    }

    public static NodeOperation create(int operationType) {
        switch (operationType) {
            case 1: {
                return new NodeAddedOperation();
            }
            case 2: {
                return new NodeModifiedOperation();
            }
            case 3: {
                return new NodeDeletedOperation();
            }
        }
        throw new IllegalArgumentException("Unknown operation type: " + operationType);
    }

    public boolean hasId() {
        return this.id != null;
    }

    public NodeId getId() {
        return this.id;
    }

    public void setId(NodeId id) {
        this.id = id;
    }

    public NodeDefId getDefintionId() {
        return this.definitionId;
    }

    public boolean hasDefinitionId() {
        return this.definitionId != null;
    }

    public void setDefintionId(NodeDefId defintionId) {
        this.definitionId = defintionId;
    }
}

