/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene;

import java.io.IOException;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Map;
import org.apache.jackrabbit.core.query.lucene.FieldNames;
import org.apache.jackrabbit.core.query.lucene.HierarchyResolver;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.HitCollector;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.search.Weight;

class ParentAxisQuery
extends Query {
    private static final Float DEFAULT_SCORE = new Float(1.0f);
    private final Query contextQuery;
    private final String nameTest;
    private Scorer contextScorer;

    ParentAxisQuery(Query context, String nameTest) {
        this.contextQuery = context;
        this.nameTest = nameTest;
    }

    protected Weight createWeight(Searcher searcher) {
        return new ParentAxisWeight(searcher);
    }

    public String toString(String field) {
        return "ParentAxisQuery";
    }

    private class ParentAxisScorer
    extends Scorer {
        private final IndexReader reader;
        private final HierarchyResolver hResolver;
        private BitSet hits;
        private final Map scores;
        private int nextDoc;

        protected ParentAxisScorer(Similarity similarity, IndexReader reader, HierarchyResolver resolver) {
            super(similarity);
            this.scores = new HashMap();
            this.nextDoc = -1;
            this.reader = reader;
            this.hResolver = resolver;
        }

        public boolean next() throws IOException {
            this.calculateParent();
            this.nextDoc = this.hits.nextSetBit(this.nextDoc + 1);
            return this.nextDoc > -1;
        }

        public int doc() {
            return this.nextDoc;
        }

        public float score() throws IOException {
            Float score = (Float)this.scores.get(new Integer(this.nextDoc));
            if (score == null) {
                score = DEFAULT_SCORE;
            }
            return score.floatValue();
        }

        public boolean skipTo(int target) throws IOException {
            this.nextDoc = this.hits.nextSetBit(target);
            return this.nextDoc > -1;
        }

        public Explanation explain(int doc) throws IOException {
            throw new UnsupportedOperationException();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void calculateParent() throws IOException {
            if (this.hits == null) {
                this.hits = new BitSet(this.reader.maxDoc());
                final IOException[] ex = new IOException[1];
                ParentAxisQuery.this.contextScorer.score(new HitCollector(){

                    public void collect(int doc, float score) {
                        try {
                            doc = ParentAxisScorer.this.hResolver.getParent(doc);
                            if (doc != -1) {
                                ParentAxisScorer.this.hits.set(doc);
                                if (score != DEFAULT_SCORE.floatValue()) {
                                    ParentAxisScorer.this.scores.put(new Integer(doc), new Float(score));
                                }
                            }
                        }
                        catch (IOException e) {
                            ex[0] = e;
                        }
                    }
                });
                if (ex[0] != null) {
                    throw ex[0];
                }
                if (ParentAxisQuery.this.nameTest != null) {
                    TermDocs tDocs = this.reader.termDocs(new Term(FieldNames.LABEL, ParentAxisQuery.this.nameTest));
                    try {
                        int i = this.hits.nextSetBit(0);
                        while (i >= 0) {
                            if (!tDocs.skipTo(i)) {
                                this.hits.clear(i);
                            }
                            i = this.hits.nextSetBit(i + 1);
                        }
                    }
                    finally {
                        tDocs.close();
                    }
                }
            }
        }
    }

    private class ParentAxisWeight
    implements Weight {
        private final Searcher searcher;

        private ParentAxisWeight(Searcher searcher) {
            this.searcher = searcher;
        }

        public Query getQuery() {
            return ParentAxisQuery.this;
        }

        public float getValue() {
            return 1.0f;
        }

        public float sumOfSquaredWeights() throws IOException {
            return 1.0f;
        }

        public void normalize(float norm) {
        }

        public Scorer scorer(IndexReader reader) throws IOException {
            ParentAxisQuery.this.contextScorer = ParentAxisQuery.this.contextQuery.weight(this.searcher).scorer(reader);
            HierarchyResolver resolver = (HierarchyResolver)reader;
            return new ParentAxisScorer(this.searcher.getSimilarity(), reader, resolver);
        }

        public Explanation explain(IndexReader reader, int doc) throws IOException {
            return new Explanation();
        }
    }
}

