/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache;

import java.util.LinkedList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.TreeCache;
import org.jgroups.blocks.MethodCall;

public class ReplicationQueue {
    TreeCache cache = null;
    long interval = 5000L;
    long max_elements = 500L;
    LinkedList elements = new LinkedList();
    Timer timer = null;
    MyTask task = null;
    static Log log = LogFactory.getLog((Class)(class$org$jboss$cache$ReplicationQueue == null ? (class$org$jboss$cache$ReplicationQueue = ReplicationQueue.class$("org.jboss.cache.ReplicationQueue")) : class$org$jboss$cache$ReplicationQueue));
    static /* synthetic */ Class class$org$jboss$cache$ReplicationQueue;

    public ReplicationQueue() {
    }

    public ReplicationQueue(TreeCache cache, long interval, long max_elements) {
        this.cache = cache;
        this.interval = interval;
        this.max_elements = max_elements;
    }

    public long getInterval() {
        return this.interval;
    }

    public void setInterval(long interval) {
        this.interval = interval;
        this.stop();
        this.start();
    }

    public long getMax_elements() {
        return this.max_elements;
    }

    public void setMax_elements(long max_elements) {
        this.max_elements = max_elements;
    }

    public void start() {
        if (this.interval > 0L) {
            if (this.task == null) {
                this.task = new MyTask();
            }
            if (this.timer == null) {
                this.timer = new Timer(true);
                this.timer.schedule((TimerTask)this.task, 500L, this.interval);
            }
        }
    }

    public void stop() {
        if (this.task != null) {
            this.task.cancel();
            this.task = null;
        }
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(MethodCall job) {
        LinkedList linkedList = this.elements;
        synchronized (linkedList) {
            if (job != null && !this.elements.contains(job)) {
                this.elements.add(job);
            }
            if ((long)this.elements.size() >= this.max_elements) {
                this.flush();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        List l;
        LinkedList linkedList = this.elements;
        synchronized (linkedList) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("flush(): flushing repl queue (num elements=" + this.elements.size() + ")"));
            }
            l = (List)this.elements.clone();
            this.elements.clear();
        }
        try {
            this.cache.callRemoteMethods(null, TreeCache.replicateAllMethod, new Object[]{l}, false, true, 5000L);
        }
        catch (Throwable t) {
            log.error((Object)("failed replicating " + l.size() + " elements in replication queue"), t);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public class MyTask
    extends TimerTask {
        public void run() {
            ReplicationQueue.this.flush();
        }
    }
}

