/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.interceptors;

import EDU.oswego.cs.dl.util.concurrent.ConcurrentHashMap;
import java.lang.reflect.Method;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import javax.transaction.Synchronization;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.jboss.cache.DataNode;
import org.jboss.cache.Fqn;
import org.jboss.cache.GlobalTransaction;
import org.jboss.cache.TransactionEntry;
import org.jboss.cache.TransactionTable;
import org.jboss.cache.TreeCache;
import org.jboss.cache.interceptors.AbstractLockInterceptor;
import org.jboss.cache.interceptors.OrderedSynchronizationHandler;
import org.jboss.cache.lock.IdentityLock;
import org.jboss.cache.lock.IsolationLevel;
import org.jboss.cache.lock.LockingException;
import org.jboss.cache.lock.TimeoutException;
import org.jgroups.blocks.MethodCall;

public class PessimisticLockInterceptor
extends AbstractLockInterceptor {
    private TransactionManager tx_mgr = null;
    TransactionTable tx_table = null;
    Map lock_table;
    private long lock_acquisition_timeout;
    private Map transactions = new ConcurrentHashMap(16);
    private Map rollbackTransactions = new ConcurrentHashMap(16);
    private static final Object NULL = new Object();

    public void setCache(TreeCache cache) {
        super.setCache(cache);
        this.tx_mgr = cache.getTransactionManager();
        this.tx_table = cache.getTransactionTable();
        this.lock_table = cache.getLockTable();
        this.lock_acquisition_timeout = cache.getLockAcquisitionTimeout();
    }

    public Object invoke(MethodCall m) throws Throwable {
        Transaction tx = null;
        GlobalTransaction gtx = null;
        Fqn fqn = null;
        int lock_type = 0;
        long lock_timeout = this.lock_acquisition_timeout;
        Method meth = m.getMethod();
        Object[] args = m.getArgs();
        boolean recursive = false;
        boolean createIfNotExists = false;
        if (this.tx_mgr != null && (tx = this.tx_mgr.getTransaction()) != null && this.isValid(tx)) {
            if (!this.transactions.containsKey(tx)) {
                gtx = this.cache.getCurrentTransaction(tx);
                if (gtx == null) {
                    throw new Exception("failed to get global transaction");
                }
                try {
                    OrderedSynchronizationHandler handler = OrderedSynchronizationHandler.getInstance(tx);
                    SynchronizationHandler myHandler = new SynchronizationHandler(gtx, tx, this.cache);
                    handler.registerAtTail(myHandler);
                    this.transactions.put(tx, NULL);
                }
                catch (Exception e) {
                    this.log.error((Object)("registration for tx=" + tx + " with transaction manager failed, running without TX"), (Throwable)e);
                }
            } else {
                gtx = this.cache.getTransactionTable().get(tx);
            }
        } else if (tx != null) {
            gtx = (GlobalTransaction)this.rollbackTransactions.get(tx);
        }
        if (meth.equals(TreeCache.putDataMethodLocal) || meth.equals(TreeCache.putDataEraseMethodLocal) || meth.equals(TreeCache.putKeyValMethodLocal) || meth.equals(TreeCache.putFailFastKeyValueMethodLocal)) {
            createIfNotExists = true;
            fqn = (Fqn)args[1];
            lock_type = 2;
            if (meth.equals(TreeCache.putFailFastKeyValueMethodLocal)) {
                lock_timeout = (Long)args[5];
            }
        } else if (meth.equals(TreeCache.removeNodeMethodLocal)) {
            fqn = (Fqn)args[1];
            lock_type = 2;
            recursive = true;
        } else if (meth.equals(TreeCache.removeKeyMethodLocal) || meth.equals(TreeCache.removeDataMethodLocal)) {
            fqn = (Fqn)args[1];
            lock_type = 2;
        } else if (meth.equals(TreeCache.evictNodeMethodLocal)) {
            fqn = (Fqn)args[0];
            lock_type = 2;
        } else if (meth.equals(TreeCache.addChildMethodLocal)) {
            fqn = (Fqn)args[1];
            lock_type = 2;
        } else if (meth.equals(TreeCache.getKeyValueMethodLocal)) {
            fqn = (Fqn)args[0];
            lock_type = 1;
        } else if (meth.equals(TreeCache.getNodeMethodLocal)) {
            fqn = (Fqn)args[0];
            lock_type = 1;
        } else if (meth.equals(TreeCache.getKeysMethodLocal)) {
            fqn = (Fqn)args[0];
            lock_type = 1;
        } else if (meth.equals(TreeCache.getChildrenNamesMethodLocal) || meth.equals(TreeCache.releaseAllLocksMethodLocal) || meth.equals(TreeCache.printMethodLocal)) {
            fqn = (Fqn)args[0];
            lock_type = 1;
        } else if (meth.equals(TreeCache.lockMethodLocal)) {
            fqn = (Fqn)args[0];
            lock_type = (Integer)args[1];
            recursive = (Boolean)args[2];
        }
        if (fqn != null) {
            if (createIfNotExists) {
                do {
                    this.lock(fqn, gtx, lock_type, recursive, lock_timeout, createIfNotExists);
                } while (!this.cache.exists(fqn));
            } else {
                this.lock(fqn, gtx, lock_type, recursive, lock_timeout, createIfNotExists);
            }
        } else if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("bypassed locking as method " + m.getName() + "() doesn't require locking"));
        }
        if (meth.equals(TreeCache.lockMethodLocal)) {
            return null;
        }
        Object retval = super.invoke(m);
        return retval;
    }

    private void lock(Fqn fqn, GlobalTransaction gtx, int lock_type, boolean recursive, long lock_timeout, boolean createIfNotExists) throws TimeoutException, LockingException, InterruptedException {
        DataNode child_node = null;
        Object owner = gtx != null ? gtx : Thread.currentThread();
        boolean acquired = false;
        if (fqn == null) {
            this.log.error((Object)"fqn is null - this should not be the case");
            return;
        }
        int treeNodeSize = fqn.size();
        if (treeNodeSize == 0) {
            return;
        }
        IsolationLevel isolation_level = this.cache.getIsolationLevelClass();
        if (isolation_level == IsolationLevel.NONE) {
            lock_type = 0;
        }
        DataNode n = this.cache.getRoot();
        int i = 0;
        while (i < treeNodeSize) {
            Object child_name = fqn.get(i);
            child_node = (DataNode)n.getOrCreateChild(child_name, gtx, createIfNotExists);
            if (child_node == null) {
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)("failed to find or create child " + child_name + " of node " + n.getFqn()));
                }
                return;
            }
            if (lock_type == 0) {
                n = child_node;
            } else {
                Set acquired_locks;
                List locks;
                acquired = lock_type == 2 && i == treeNodeSize - 1 ? child_node.acquire(owner, lock_timeout, 2) : child_node.acquire(owner, lock_timeout, 1);
                if (acquired) {
                    if (gtx != null) {
                        this.cache.getTransactionTable().addLock(gtx, child_node.getLock());
                    } else {
                        IdentityLock l = child_node.getLock();
                        locks = (LinkedList<IdentityLock>)this.lock_table.get(Thread.currentThread());
                        if (locks == null) {
                            locks = new LinkedList<IdentityLock>();
                            this.lock_table.put(Thread.currentThread(), locks);
                        }
                        if (!locks.contains(l)) {
                            locks.add(l);
                        }
                    }
                }
                if (recursive && i == treeNodeSize - 1 && (acquired_locks = child_node.acquireAll(owner, lock_timeout, lock_type)).size() > 0) {
                    if (gtx != null) {
                        this.cache.getTransactionTable().addLocks(gtx, acquired_locks);
                    } else {
                        locks = (List)this.lock_table.get(Thread.currentThread());
                        if (locks == null) {
                            locks = new LinkedList();
                            this.lock_table.put(Thread.currentThread(), locks);
                        }
                        locks.addAll(acquired_locks);
                    }
                }
                n = child_node;
            }
            ++i;
        }
    }

    private void commit(GlobalTransaction gtx) {
        TransactionEntry entry;
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("committing cache with gtx " + gtx));
        }
        if ((entry = this.tx_table.get(gtx)) == null) {
            this.log.error((Object)("entry for transaction " + gtx + " not found (maybe already committed)"));
            return;
        }
        LinkedList list = new LinkedList(entry.getLocks());
        int i = list.size() - 1;
        while (i >= 0) {
            IdentityLock lock = (IdentityLock)list.get(i);
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("releasing lock for " + lock.getFqn() + " (" + lock + ")"));
            }
            lock.release(gtx);
            --i;
        }
        entry.getLocks().clear();
        Transaction ltx = entry.getTransaction();
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("removing local transaction " + ltx + " and global transaction " + gtx));
        }
        this.tx_table.remove(ltx);
        this.tx_table.remove(gtx);
    }

    private void rollback(GlobalTransaction tx) {
        TransactionEntry entry = this.tx_table.get(tx);
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("called to rollback cache with GlobalTransaction=" + tx));
        }
        if (entry == null) {
            this.log.error((Object)("entry for transaction " + tx + " not found (transaction has possibly already been rolled back)"));
            return;
        }
        Transaction ltx = entry.getTransaction();
        this.rollbackTransactions.put(ltx, tx);
        LinkedList undo_ops = new LinkedList(entry.getUndoOperations());
        ListIterator it = undo_ops.listIterator(undo_ops.size());
        while (it.hasPrevious()) {
            MethodCall undo_op = (MethodCall)it.previous();
            try {
                Object retval = undo_op.invoke((Object)this.cache);
                if (retval == null || !(retval instanceof Throwable)) continue;
                this.log.error((Object)("undo operation failed, error=" + retval));
            }
            catch (Throwable t) {
                this.log.error((Object)"undo operation failed", t);
            }
        }
        ListIterator it2 = new LinkedList(entry.getNodes()).listIterator(entry.getNodes().size());
        while (it2.hasPrevious()) {
            Fqn node_name = (Fqn)it2.previous();
            try {
                this.cache._remove(tx, node_name, false);
            }
            catch (Throwable t) {
                this.log.error((Object)("failed removing node \"" + node_name + "\""), t);
            }
        }
        LinkedList list = new LinkedList(entry.getLocks());
        int i = list.size() - 1;
        while (i >= 0) {
            IdentityLock lock = (IdentityLock)list.get(i);
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("releasing lock for " + lock.getFqn() + " (" + lock + ")"));
            }
            lock.release(tx);
            --i;
        }
        entry.getLocks().clear();
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("removing local transaction " + ltx + " and global transaction " + tx));
        }
        this.tx_table.remove(ltx);
        this.tx_table.remove(tx);
        this.rollbackTransactions.remove(ltx);
    }

    class SynchronizationHandler
    implements Synchronization {
        GlobalTransaction gtx = null;
        Transaction tx = null;
        TreeCache cache = null;

        SynchronizationHandler(GlobalTransaction gtx, Transaction tx, TreeCache cache) {
            this.gtx = gtx;
            this.cache = cache;
            this.tx = tx;
        }

        public void beforeCompletion() {
        }

        public void afterCompletion(int status) {
            PessimisticLockInterceptor.this.transactions.remove(this.tx);
            switch (status) {
                case 3: {
                    PessimisticLockInterceptor.this.commit(this.gtx);
                    break;
                }
                case 1: 
                case 4: {
                    if (PessimisticLockInterceptor.this.log.isDebugEnabled()) {
                        PessimisticLockInterceptor.this.log.debug((Object)"rolling back transaction");
                    }
                    PessimisticLockInterceptor.this.rollback(this.gtx);
                    break;
                }
                default: {
                    PessimisticLockInterceptor.this.rollback(this.gtx);
                    throw new IllegalStateException("failed rolling back transaction: " + status);
                }
            }
        }
    }
}

