/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.lock;

import EDU.oswego.cs.dl.util.concurrent.ConcurrentReaderHashMap;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.jboss.cache.lock.OwnerNotExistedException;

public class LockMap {
    public static final int OWNER_ANY = 0;
    public static final int OWNER_READ = 1;
    public static final int OWNER_WRITE = 2;
    public static final Object NULL = new Object();
    private Object writeOwner_ = null;
    private final Object writeOwnerLock = new Object();
    private final Map readOwnerList_ = new ConcurrentReaderHashMap();

    public boolean isOwner(Object caller, int ownership) {
        switch (ownership) {
            case 0: {
                if ((this.writeOwner_ == null || !caller.equals(this.writeOwner_)) && !this.readOwnerList_.containsKey(caller)) break;
                return true;
            }
            case 1: {
                if (!this.readOwnerList_.containsKey(caller)) break;
                return true;
            }
            case 2: {
                if (this.writeOwner_ == null || !caller.equals(this.writeOwner_)) break;
                return true;
            }
        }
        return false;
    }

    public void addReader(Object owner) {
        this.readOwnerList_.put(owner, NULL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setWriterIfNotNull(Object owner) {
        Object object = this.writeOwnerLock;
        synchronized (object) {
            if (this.writeOwner_ != null) {
                throw new IllegalStateException("there is already a writer holding the lock: " + this.writeOwner_);
            }
            this.writeOwner_ = owner;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object setWriter(Object owner) {
        Object old;
        Object object = this.writeOwnerLock;
        synchronized (object) {
            old = this.writeOwner_;
            this.writeOwner_ = owner;
        }
        return old;
    }

    public boolean upgrade(Object owner) throws OwnerNotExistedException {
        Object old_value = this.readOwnerList_.remove(owner);
        if (old_value == null) {
            throw new OwnerNotExistedException("Can't upgrade lock. Read lock owner did not exist");
        }
        this.setWriter(owner);
        return true;
    }

    public Set readerOwners() {
        return Collections.unmodifiableSet(this.readOwnerList_.keySet());
    }

    public Object writerOwner() {
        return this.writeOwner_;
    }

    public void removeReader(Object owner) {
        this.readOwnerList_.remove(owner);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeWriter() {
        Object object = this.writeOwnerLock;
        synchronized (object) {
            this.writeOwner_ = null;
        }
    }

    public void removeAll() {
        this.removeWriter();
        this.readOwnerList_.clear();
    }

    public String printInfo() {
        StringBuffer buf = new StringBuffer(64);
        buf.append("Read lock owners: ").append(this.readOwnerList_).append('\n');
        buf.append("Write lock owner: ").append(this.writeOwner_).append('\n');
        return buf.toString();
    }

    public boolean isReadLocked() {
        return this.readOwnerList_.size() > 0;
    }
}

