/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.contexts;

import java.util.ArrayList;
import java.util.Enumeration;
import org.jboss.seam.Component;
import org.jboss.seam.ScopeType;
import org.jboss.seam.Seam;
import org.jboss.seam.contexts.Context;
import org.jboss.seam.contexts.ContextAdaptor;
import org.jboss.seam.contexts.Lifecycle;
import org.jboss.seam.core.Events;

public class WebSessionContext
implements Context {
    private ContextAdaptor session;

    public ScopeType getType() {
        return ScopeType.SESSION;
    }

    private String getKey(String name) {
        return name;
    }

    public WebSessionContext(ContextAdaptor session) {
        this.session = session;
    }

    public Object get(String name) {
        return this.session.getAttribute(this.getKey(name));
    }

    public void set(String name, Object value) {
        if (Events.exists()) {
            Events.instance().raiseEvent("org.jboss.seam.preSetVariable." + name, new Object[0]);
        }
        this.session.setAttribute(this.getKey(name), value);
        if (Events.exists()) {
            Events.instance().raiseEvent("org.jboss.seam.postSetVariable." + name, new Object[0]);
        }
    }

    public boolean isSet(String name) {
        return this.get(name) != null;
    }

    public void remove(String name) {
        if (Events.exists()) {
            Events.instance().raiseEvent("org.jboss.seam.preRemoveVariable." + name, new Object[0]);
        }
        this.session.removeAttribute(this.getKey(name));
        if (Events.exists()) {
            Events.instance().raiseEvent("org.jboss.seam.postRemoveVariable." + name, new Object[0]);
        }
    }

    public String[] getNames() {
        Enumeration names = this.session.getAttributeNames();
        ArrayList<String> results = new ArrayList<String>();
        String prefix = ScopeType.CONVERSATION.getPrefix();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            if (name.contains(prefix) || this.session.getAttribute(name) == null) continue;
            results.add(name);
        }
        return results.toArray(new String[0]);
    }

    public Object get(Class clazz) {
        return this.get(Component.getComponentName(clazz));
    }

    public void flush() {
        for (String name : this.getNames()) {
            boolean dirty;
            Object attribute = this.session.getAttribute(name);
            boolean bl = dirty = attribute != null && (Lifecycle.isAttributeDirty(attribute) || Seam.isEntityClass(attribute.getClass()));
            if (!dirty) continue;
            this.session.setAttribute(name, attribute);
        }
    }
}

