/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.smooks.scripting;

import groovy.lang.GroovyClassLoader;
import java.io.UnsupportedEncodingException;
import org.milyn.cdr.SmooksResourceConfiguration;
import org.milyn.delivery.ContentDeliveryUnit;
import org.milyn.delivery.ContentDeliveryUnitCreator;
import org.milyn.delivery.dom.DOMElementVisitor;
import org.milyn.delivery.dom.serialize.SerializationUnit;

public class GroovyContentDeliveryUnitCreator
implements ContentDeliveryUnitCreator {
    public ContentDeliveryUnit create(SmooksResourceConfiguration configuration) throws InstantiationException {
        GroovyClassLoader groovyClassLoader = new GroovyClassLoader(this.getClass().getClassLoader());
        try {
            byte[] groovyScriptData = configuration.getBytes();
            if (groovyScriptData == null) {
                throw new InstantiationException("No resource specified in either the resource path or resource 'resdata'.");
            }
            Class groovyClass = groovyClassLoader.parseClass(new String(groovyScriptData, "UTF-8"));
            Object groovyObject = groovyClass.newInstance();
            if (groovyObject instanceof DOMElementVisitor || groovyObject instanceof SerializationUnit) {
                ContentDeliveryUnit groovyResource = (ContentDeliveryUnit)groovyObject;
                groovyResource.setConfiguration(configuration);
                return groovyResource;
            }
            throw new InstantiationException("Invalid Groovy script " + configuration.getResource() + ".  Must implement one of the following Smooks interfaces:\n\t\t1. " + DOMElementVisitor.class.getName() + ", or\n\t\t2. " + SerializationUnit.class.getName() + ".");
        }
        catch (IllegalAccessException e) {
            InstantiationException initE = new InstantiationException("Error constructing class from Groovy script " + configuration.getResource());
            initE.initCause(e);
            throw initE;
        }
        catch (UnsupportedEncodingException e) {
            InstantiationException initE = new InstantiationException("Error decoding Groovy script " + configuration.getResource());
            initE.initCause(e);
            throw initE;
        }
    }
}

