/*
 * Decompiled with CFR 0.152.
 */
package org.mvel.conversion;

import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.Map;
import org.mvel.ConversionException;
import org.mvel.ConversionHandler;
import org.mvel.DataConversion;
import org.mvel.conversion.Converter;

public class PrimArrayHandler
implements ConversionHandler {
    private final Map<Class, Converter> CNV = new HashMap<Class, Converter>();
    private final Class primitiveType;

    public PrimArrayHandler(Class type) {
        Class<?> clazz;
        Class<?> clazz2;
        this.primitiveType = type;
        try {
            clazz2 = Class.forName("[Ljava.lang.Object;");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        this.CNV.put(clazz2, new Converter(){

            public Object convert(Object o) {
                return PrimArrayHandler.handleLooseTypeConversion(o.getClass(), (Object[])o, PrimArrayHandler.this.primitiveType);
            }
        });
        try {
            clazz = Class.forName("[Ljava.lang.String;");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        this.CNV.put(clazz, new Converter(){

            public Object convert(Object o) {
                return PrimArrayHandler.handleLooseTypeConversion(o.getClass(), (String[])o, PrimArrayHandler.this.primitiveType);
            }
        });
    }

    public Object convertFrom(Object in) {
        if (!this.CNV.containsKey(in.getClass())) {
            throw new ConversionException("cannot convert type: " + in.getClass().getName() + " to: " + this.primitiveType.getName());
        }
        return this.CNV.get(in.getClass()).convert(in);
    }

    public boolean canConvertFrom(Class cls) {
        return this.CNV.containsKey(cls);
    }

    private static Object handleLooseTypeConversion(Class sourceType, Object[] input, Class targetType) {
        Class<?> targType = targetType.getComponentType();
        Object target = Array.newInstance(targType, input.length);
        if (input.length > 0 && DataConversion.canConvert(targetType.getComponentType(), sourceType.getComponentType())) {
            int i = 0;
            while (i < input.length) {
                Array.set(target, i, DataConversion.convert(input[i], targType));
                ++i;
            }
        } else {
            throw new ConversionException("cannot convert to type: " + targetType.getComponentType().getName() + "[] from " + sourceType.getComponentType().getName());
        }
        return target;
    }
}

