/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.xml;

import java.util.Stack;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.parsing.ComponentDefinition;
import org.springframework.beans.factory.parsing.CompositeComponentDefinition;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.xml.BeanDefinitionParserDelegate;
import org.springframework.beans.factory.xml.XmlReaderContext;

public final class ParserContext {
    private final XmlReaderContext readerContext;
    private final BeanDefinitionParserDelegate delegate;
    private BeanDefinition containingBeanDefinition;
    private final Stack containingComponents = new Stack();

    public ParserContext(XmlReaderContext readerContext, BeanDefinitionParserDelegate delegate) {
        this.readerContext = readerContext;
        this.delegate = delegate;
    }

    public ParserContext(XmlReaderContext readerContext, BeanDefinitionParserDelegate delegate, BeanDefinition containingBeanDefinition) {
        this.readerContext = readerContext;
        this.delegate = delegate;
        this.containingBeanDefinition = containingBeanDefinition;
    }

    public XmlReaderContext getReaderContext() {
        return this.readerContext;
    }

    public BeanDefinitionRegistry getRegistry() {
        return this.getReaderContext().getRegistry();
    }

    public BeanDefinitionParserDelegate getDelegate() {
        return this.delegate;
    }

    public BeanDefinition getContainingBeanDefinition() {
        return this.containingBeanDefinition;
    }

    public boolean isNested() {
        return this.getContainingBeanDefinition() != null;
    }

    public Object extractSource(Object sourceCandidate) {
        return this.getReaderContext().extractSource(sourceCandidate);
    }

    public CompositeComponentDefinition getContainingComponent() {
        return !this.containingComponents.isEmpty() ? (CompositeComponentDefinition)this.containingComponents.lastElement() : null;
    }

    public void pushContainingComponent(CompositeComponentDefinition containingComponent) {
        this.containingComponents.push(containingComponent);
    }

    public CompositeComponentDefinition popContainingComponent() {
        return (CompositeComponentDefinition)this.containingComponents.pop();
    }

    public void popAndRegisterContainingComponent() {
        this.registerComponent(this.popContainingComponent());
    }

    public void registerComponent(ComponentDefinition component) {
        CompositeComponentDefinition containingComponent = this.getContainingComponent();
        if (containingComponent != null) {
            containingComponent.addNestedComponent(component);
        } else {
            this.getReaderContext().fireComponentRegistered(component);
        }
    }
}

