/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jms.client.delegate;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;
import javax.jms.JMSException;
import org.jboss.jms.client.state.HierarchicalState;
import org.jboss.jms.exception.MessagingJMSException;
import org.jboss.jms.exception.MessagingNetworkFailureException;
import org.jboss.jms.wireformat.RequestSupport;
import org.jboss.jms.wireformat.ResponseSupport;
import org.jboss.logging.Logger;
import org.jboss.messaging.util.Streamable;
import org.jboss.remoting.CannotConnectException;
import org.jboss.remoting.Client;
import org.jboss.remoting.ConnectionFailedException;

public abstract class DelegateSupport
implements Streamable,
Serializable {
    private static final long serialVersionUID = -1362079381836473747L;
    private static final Logger log = Logger.getLogger(DelegateSupport.class);
    private static boolean trace = log.isTraceEnabled();
    protected String id;
    protected transient HierarchicalState state;
    protected transient byte version;
    protected transient Client client;

    public DelegateSupport(String id) {
        this.id = id;
        this.state = null;
    }

    public DelegateSupport() {
        this("NO_ID_SET");
    }

    public String getName() {
        return this.getClass().getName();
    }

    public void read(DataInputStream in) throws Exception {
        this.id = in.readUTF();
    }

    public void write(DataOutputStream out) throws Exception {
        out.writeUTF(this.id);
    }

    public HierarchicalState getState() {
        return this.state;
    }

    public void setState(HierarchicalState state) {
        this.state = state;
        this.version = state.getVersionToUse().getProviderIncrementingVersion();
    }

    public String getID() {
        return this.id;
    }

    public void synchronizeWith(DelegateSupport newDelegate) throws Exception {
        this.id = newDelegate.getID();
    }

    protected Object doInvoke(Client client, RequestSupport req) throws JMSException {
        return this.doInvoke(client, req, false);
    }

    protected Object doInvokeOneway(Client client, RequestSupport req) throws JMSException {
        return this.doInvoke(client, req, true);
    }

    private Object doInvoke(Client client, RequestSupport req, boolean oneWay) throws JMSException {
        try {
            Object resp = null;
            if (oneWay) {
                if (trace) {
                    log.trace((Object)(this + " invoking " + req + " asynchronously on server using " + client));
                }
                client.invokeOneway((Object)req);
                if (trace) {
                    log.trace((Object)(this + " asynchronously invoked " + req + " on server, no response expected"));
                }
            } else {
                if (trace) {
                    log.trace((Object)(this + " invoking " + req + " synchronously on server using " + client));
                }
                resp = client.invoke((Object)req);
                if (trace) {
                    log.trace((Object)(this + " got server response for " + req + ": " + resp));
                }
            }
            Object res = null;
            if (resp instanceof ResponseSupport) {
                res = ((ResponseSupport)resp).getResponse();
            }
            return res;
        }
        catch (Throwable t) {
            throw this.handleThrowable(t);
        }
    }

    public JMSException handleThrowable(Throwable t) {
        RuntimeException re;
        Throwable initCause;
        if (t instanceof JMSException) {
            return (JMSException)t;
        }
        if (t instanceof CannotConnectException || t instanceof IOException || t instanceof ConnectionFailedException) {
            return new MessagingNetworkFailureException((Exception)t);
        }
        if (t instanceof RuntimeException && (initCause = (re = (RuntimeException)t).getCause()) != null) {
            do {
                if (!(initCause instanceof CannotConnectException) && !(initCause instanceof IOException) && !(initCause instanceof ConnectionFailedException)) continue;
                return new MessagingNetworkFailureException((Exception)initCause);
            } while ((initCause = initCause.getCause()) != null);
        }
        return new MessagingJMSException("Failed to invoke", t);
    }

    public Client getClient() {
        return this.client;
    }
}

