/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpel.graph.exe.state;

import org.jbpm.bpel.graph.exe.ScopeInstance;
import org.jbpm.bpel.graph.exe.ScopeState;
import org.jbpm.bpel.graph.exe.state.EndedState;
import org.jbpm.bpel.graph.exe.state.StateUtil;
import org.jbpm.bpel.graph.scope.Handler;

public class FaultingState
extends ScopeState {
    private static final long serialVersionUID = 1L;
    public static final ScopeState TERMINATING_PRIMARY_ACTIVITY = new FaultingState("terminatingPrimaryActivityOnFault", 2){
        private static final long serialVersionUID = 1L;

        public void childrenTerminated(ScopeInstance scope) {
            Handler handler = scope.getFaultHandler();
            if (handler != null) {
                scope.setState(FAULTING_WITH_HANDLER);
                StateUtil.invokeHandler(scope, handler);
            } else {
                scope.setState(FAULTING_WITHOUT_HANDLER);
                StateUtil.invokeDefaultCompensation(scope);
            }
        }
    };
    public static final ScopeState FAULTING_WITHOUT_HANDLER = new FaultingState("faultingWithoutHandler", 3){
        private static final long serialVersionUID = 1L;

        public void childrenCompensated(ScopeInstance scope) {
            EndedState.enterFaulted(scope);
        }

        public void faulted(ScopeInstance scope) {
            EndedState.enterFaulted(scope);
        }
    };
    public static final ScopeState FAULTING_WITH_HANDLER = new FaultingState("faultingWithHandler", 4){
        private static final long serialVersionUID = 1L;

        public void completed(ScopeInstance scope) {
            EndedState.enterExited(scope);
        }

        public void faulted(ScopeInstance scope) {
            scope.setState(TERMINATING_FAULT_HANDLER);
            scope.terminateChildren();
        }
    };
    public static final ScopeState TERMINATING_FAULT_HANDLER = new FaultingState("terminatingFaultHandler", 5){
        private static final long serialVersionUID = 1L;

        public void childrenTerminated(ScopeInstance scope) {
            EndedState.enterFaulted(scope);
        }
    };

    protected FaultingState(String name, int code) {
        super(name, code);
    }

    public void terminate(ScopeInstance scope) {
    }

    public static void enterFaulting(ScopeInstance scope) {
        scope.setState(TERMINATING_PRIMARY_ACTIVITY);
        scope.terminateChildren();
    }
}

