/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpel.integration.soap;

import com.ibm.wsdl.extensions.soap.SOAPConstants;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.wsdl.Binding;
import javax.wsdl.BindingFault;
import javax.wsdl.BindingOperation;
import javax.wsdl.Fault;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.Part;
import javax.wsdl.extensions.soap.SOAPBinding;
import javax.wsdl.extensions.soap.SOAPBody;
import javax.wsdl.extensions.soap.SOAPFault;
import javax.wsdl.extensions.soap.SOAPOperation;
import javax.xml.namespace.QName;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPBodyElement;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import org.jbpm.bpel.integration.soap.FaultFormat;
import org.jbpm.bpel.integration.soap.MessageDirection;
import org.jbpm.bpel.wsdl.util.WsdlUtil;
import org.jbpm.bpel.xml.util.DatatypeUtil;
import org.jbpm.bpel.xml.util.XmlUtil;
import org.w3c.dom.Element;

public class SoapFormatter {
    private final Binding binding;
    private FaultFormat faultFormat = FaultFormat.DEFAULT;
    static final /* synthetic */ boolean $assertionsDisabled;

    public SoapFormatter(Binding binding) {
        SOAPBinding soapBinding = (SOAPBinding)WsdlUtil.getExtension(binding.getExtensibilityElements(), SOAPConstants.Q_ELEM_SOAP_BINDING);
        if (soapBinding == null) {
            throw new IllegalArgumentException("non-soap binding not supported: " + binding);
        }
        String transport = soapBinding.getTransportURI();
        if (!"http://schemas.xmlsoap.org/soap/http".equals(transport)) {
            throw new IllegalArgumentException("non-http transport not supported: " + transport);
        }
        this.binding = binding;
    }

    public final Binding getBinding() {
        return this.binding;
    }

    public FaultFormat getFaultFormat() {
        return this.faultFormat;
    }

    public void setFaultFormat(FaultFormat faultFormat) {
        this.faultFormat = faultFormat;
    }

    public void writeMessage(String operation, SOAPMessage soapMessage, Map parts, MessageDirection direction) throws SOAPException {
        BindingOperation bindOperation = this.binding.getBindingOperation(operation, null, null);
        SOAPOperation soapOperation = (SOAPOperation)WsdlUtil.getExtension(bindOperation.getExtensibilityElements(), SOAPConstants.Q_ELEM_SOAP_OPERATION);
        String action = soapOperation.getSoapActionURI();
        action = action != null ? '\"' + action + '\"' : "\"\"";
        soapMessage.getSOAPPart().setMimeHeader("SOAPAction", action);
        String style = this.determineOperationStyle(soapOperation);
        if ("rpc".equals(style)) {
            this.writeRpcBody(bindOperation, direction, soapMessage.getSOAPBody(), parts);
        } else {
            this.writeDocumentBody(bindOperation, direction, soapMessage.getSOAPBody(), parts);
        }
    }

    private String determineOperationStyle(SOAPOperation soapOperation) {
        SOAPBinding soapBinding;
        String style = soapOperation.getStyle();
        if (style == null && (style = (soapBinding = (SOAPBinding)WsdlUtil.getExtension(this.getBinding().getExtensibilityElements(), SOAPConstants.Q_ELEM_SOAP_BINDING)).getStyle()) == null) {
            style = "document";
        }
        return style;
    }

    protected void writeRpcBody(BindingOperation bindOperation, MessageDirection direction, javax.xml.soap.SOAPBody body, Map parts) throws SOAPException {
        SOAPBody soapBindBody = direction.getBodyDescription(bindOperation);
        if (!"literal".equals(soapBindBody.getUse())) {
            throw new SOAPException("binding must use value 'literal' for attribute 'use' in all soapbind:body elements: " + this.binding);
        }
        String operationNamespaceUri = soapBindBody.getNamespaceURI();
        if (operationNamespaceUri == null) {
            throw new SOAPException("rpc binding must have the namespace attribute specified on contained soapbind:body elements: " + this.binding);
        }
        Operation operation = bindOperation.getOperation();
        SOAPEnvelope envelope = (SOAPEnvelope)body.getParentElement();
        Name rpcWrapperName = envelope.createName(direction.getRpcWrapperLocalName(operation), "operationNS", operationNamespaceUri);
        SOAPBodyElement rpcWrapper = body.addBodyElement(rpcWrapperName);
        List partNames = direction.getRpcBodyPartNames(soapBindBody, operation);
        List wsdlParts = SoapFormatter.getWsdlParts(partNames, direction.getMessageDefinition(operation));
        int n = parts.size();
        for (int i = 0; i < n; ++i) {
            Part wsdlPart = (Part)wsdlParts.get(i);
            if (wsdlPart.getTypeName() == null) {
                throw new SOAPException("rpc binding must refer, in its soapbind:body elements, only to wsdl:part elements defined using the type attribute: " + this.binding);
            }
            Element part = (Element)parts.get(wsdlPart.getName());
            XmlUtil.copyChildElement((SOAPElement)rpcWrapper, part);
        }
    }

    protected void writeDocumentBody(BindingOperation bindOperation, MessageDirection direction, javax.xml.soap.SOAPBody body, Map parts) throws SOAPException {
        SOAPBody soapBindBody = direction.getBodyDescription(bindOperation);
        if (!"literal".equals(soapBindBody.getUse())) {
            throw new SOAPException("binding must use value 'literal' for the use attribute in all soapbind:body elements: " + this.binding);
        }
        if (soapBindBody.getNamespaceURI() != null) {
            throw new SOAPException("document binding must not have the namespace attribute specified on contained soapbind:body elements: " + this.binding);
        }
        List partNames = soapBindBody.getParts();
        Message message = direction.getMessageDefinition(bindOperation.getOperation());
        if (partNames == null) {
            if (message.getParts().size() > 1) {
                throw new SOAPException("if a document binding does not specify attribute 'parts' on a soapbind:body element, the corresponding wsdl:message must define zero or one wsdl:parts: " + this.binding);
            }
        } else if (partNames.size() > 1) {
            throw new SOAPException("document binding must, in its soapbind:body elements, have at most one part listed in attribute 'parts': " + this.binding);
        }
        List wsdlParts = SoapFormatter.getWsdlParts(partNames, message);
        if (!$assertionsDisabled && wsdlParts.size() > 1) {
            throw new AssertionError(wsdlParts.size());
        }
        if (wsdlParts.size() == 1) {
            Part wsdlPart = (Part)wsdlParts.get(0);
            QName elementName = wsdlPart.getElementName();
            if (elementName == null) {
                throw new SOAPException("document binding must refer, in its soapbind:body elements, only to wsdl:part elements defined using attribute 'element': " + this.binding);
            }
            Element part = (Element)parts.get(wsdlPart.getName());
            if (!XmlUtil.nodeQNameEquals(part, elementName)) {
                throw new SOAPException("document binding must be serialized as an envelope with a soap:Body whose child element is an instance of the element declaration referenced by the corresponding wsdl:message part: " + this.binding);
            }
            XmlUtil.copyChildElement((SOAPElement)body, part);
        }
    }

    private static List getWsdlParts(List partNames, Message message) {
        return message.getOrderedParts(partNames);
    }

    public void readMessage(String operation, SOAPMessage message, Map parts, MessageDirection direction) throws SOAPException {
        SOAPBinding soapBinding;
        BindingOperation bindOperation = this.binding.getBindingOperation(operation, null, null);
        SOAPOperation soapOperation = (SOAPOperation)WsdlUtil.getExtension(bindOperation.getExtensibilityElements(), SOAPConstants.Q_ELEM_SOAP_OPERATION);
        String style = soapOperation.getStyle();
        if (style == null && (style = (soapBinding = (SOAPBinding)WsdlUtil.getExtension(this.binding.getExtensibilityElements(), SOAPConstants.Q_ELEM_SOAP_BINDING)).getStyle()) == null) {
            style = "document";
        }
        if ("document".equals(style)) {
            this.readDocumentBody(bindOperation, message.getSOAPBody(), parts, direction);
        } else {
            this.readRpcBody(bindOperation, message.getSOAPBody(), parts, direction);
        }
    }

    protected void readRpcBody(BindingOperation bindOperation, javax.xml.soap.SOAPBody body, Map parts, MessageDirection direction) throws SOAPException {
        SOAPBody soapBindBody = direction.getBodyDescription(bindOperation);
        if (!"literal".equals(soapBindBody.getUse())) {
            throw new SOAPException("binding must use value 'literal' for attribute 'use' in all soapbind:body elements: " + this.binding);
        }
        String operationNamespaceUri = soapBindBody.getNamespaceURI();
        if (operationNamespaceUri == null) {
            throw new SOAPException("rpc binding must have the namespace attribute specified on contained soapbind:body elements: " + this.binding);
        }
        Operation operation = bindOperation.getOperation();
        SOAPElement operationWrapper = XmlUtil.getElement((SOAPElement)body, operationNamespaceUri, direction.getRpcWrapperLocalName(operation));
        List partNames = soapBindBody.getParts();
        List wsdlParts = SoapFormatter.getWsdlParts(partNames, direction.getMessageDefinition(operation));
        int n = wsdlParts.size();
        for (int i = 0; i < n; ++i) {
            Part wsdlPart = (Part)wsdlParts.get(i);
            if (wsdlPart.getTypeName() == null) {
                throw new SOAPException("rpc binding must refer, in its soapbind:body elements, only to wsdl:part elements defined using attribute 'type': " + this.binding);
            }
            String partName = wsdlPart.getName();
            Element part = XmlUtil.createElement(partName);
            parts.put(partName, part);
            SOAPElement accessor = XmlUtil.getElement(operationWrapper, partName);
            Boolean nil = DatatypeUtil.parseBoolean(accessor.getAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "nil"));
            if (nil != Boolean.TRUE) {
                XmlUtil.copy(part, accessor);
                continue;
            }
            XmlUtil.copyAttributes(part, accessor);
        }
    }

    protected void readDocumentBody(BindingOperation bindOperation, javax.xml.soap.SOAPBody body, Map parts, MessageDirection direction) throws SOAPException {
        SOAPBody soapBindBody = direction.getBodyDescription(bindOperation);
        if (!"literal".equals(soapBindBody.getUse())) {
            throw new SOAPException("binding must use value 'literal' for attribute 'use' in all soapbind:body elements: " + this.binding);
        }
        if (soapBindBody.getNamespaceURI() != null) {
            throw new SOAPException("document binding must not have attribute 'namespace' specified on contained soapbind:body elements: " + this.binding);
        }
        List partNames = soapBindBody.getParts();
        Message message = direction.getMessageDefinition(bindOperation.getOperation());
        if (partNames == null) {
            if (message.getParts().size() > 1) {
                throw new SOAPException("if a document binding does not specify attribute 'parts' on a soapbind:body element, the corresponding wsdl:message must define zero or one wsdl:parts: " + this.binding);
            }
        } else if (partNames.size() > 1) {
            throw new SOAPException("document binding must, in its soapbind:body elements, have at most one part listed in attribute 'parts': " + this.binding);
        }
        List wsdlParts = SoapFormatter.getWsdlParts(partNames, message);
        if (!$assertionsDisabled && wsdlParts.size() > 1) {
            throw new AssertionError(wsdlParts.size());
        }
        if (wsdlParts.size() == 1) {
            Part wsdlPart = (Part)wsdlParts.get(0);
            QName elementName = wsdlPart.getElementName();
            if (elementName == null) {
                throw new SOAPException("document binding must refer, in its soapbind:body elements, only to wsdl:part elements defined using attribute 'element': " + this.binding);
            }
            Element part = XmlUtil.createElement(elementName);
            parts.put(wsdlPart.getName(), part);
            SOAPElement element = XmlUtil.getElement((SOAPElement)body, elementName);
            if (element == null) {
                throw new SOAPException("document binding must be serialized as an envelope with a soap:Body whose child element is an instance of the element declaration referenced by the corresponding wsdl:message part: " + this.binding);
            }
            Boolean nil = DatatypeUtil.parseBoolean(element.getAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "nil"));
            if (nil != Boolean.TRUE) {
                XmlUtil.copy(part, element);
            } else {
                XmlUtil.copyAttributes(part, element);
            }
        }
    }

    public void writeFault(String operation, SOAPMessage message, QName code, String reason, String fault, Map parts) throws SOAPException {
        SOAPElement faultElem = this.faultFormat.addFault(message.getSOAPBody());
        this.faultFormat.setCode(faultElem, code);
        this.faultFormat.setReason(faultElem, reason);
        if (fault == null) {
            return;
        }
        BindingOperation bindOperation = this.binding.getBindingOperation(operation, null, null);
        BindingFault bindFault = bindOperation.getBindingFault(fault);
        if (bindFault == null) {
            throw new SOAPException("fault '" + fault + "' not found: " + this.binding);
        }
        SOAPFault soapBindFault = (SOAPFault)WsdlUtil.getExtension(bindFault.getExtensibilityElements(), SOAPConstants.Q_ELEM_SOAP_FAULT);
        if (soapBindFault.getName() == null) {
            throw new SOAPException("a wsdl:binding must have attribute 'name' specified on all contained soapbind:fault elements: " + this.binding);
        }
        if (!soapBindFault.getName().equals(fault)) {
            throw new SOAPException("value of attribute 'name' on a soapbind:fault element must match the value of attribute 'name' on its parent wsdl:fault element: " + this.binding);
        }
        if (!"literal".equals(soapBindFault.getUse())) {
            throw new SOAPException("binding must use value 'literal' for attribute 'use' in all soapbind:fault elements: " + this.binding);
        }
        if (soapBindFault.getNamespaceURI() != null) {
            throw new SOAPException("document binding must not have attribute 'namespace' specified on contained soapbind:fault elements: " + this.binding);
        }
        Fault wsdlFault = bindOperation.getOperation().getFault(fault);
        Map wsdlParts = wsdlFault.getMessage().getParts();
        if (wsdlParts.size() != 1) {
            throw new SOAPException("fault messages must have a single part: " + this.binding);
        }
        Part wsdlPart = (Part)wsdlParts.values().iterator().next();
        QName elementName = wsdlPart.getElementName();
        if (elementName == null) {
            throw new SOAPException("binding must refer, in each of its soapbind:fault elements, only to wsdl:parts that have been defined using attribute 'element': " + this.binding);
        }
        Element part = (Element)parts.get(wsdlPart.getName());
        if (!XmlUtil.nodeQNameEquals(part, elementName)) {
            throw new SOAPException("soapbind:fault element does not match the given contents: " + this.binding);
        }
        this.faultFormat.addDetail(faultElem, parts);
    }

    public Fault readFault(String operation, SOAPMessage message, Map parts) throws SOAPException {
        javax.xml.soap.SOAPBody bodyElem = message.getSOAPBody();
        SOAPElement faultElem = XmlUtil.getElement((SOAPElement)bodyElem, bodyElem.getNamespaceURI(), "Fault");
        SOAPElement detail = XmlUtil.getElement(faultElem, "detail");
        if (detail == null) {
            throw new SOAPException("soap fault does not include a detail element");
        }
        BindingOperation bindOperation = this.binding.getBindingOperation(operation, null, null);
        Iterator wsdlFaultIt = bindOperation.getOperation().getFaults().values().iterator();
        while (wsdlFaultIt.hasNext()) {
            Fault wsdlFault = (Fault)wsdlFaultIt.next();
            Map wsdlParts = wsdlFault.getMessage().getParts();
            if (wsdlParts.size() != 1) {
                throw new SOAPException("multiple parts not supported in fault");
            }
            Part wsdlPart = (Part)wsdlParts.values().iterator().next();
            QName elementName = wsdlPart.getElementName();
            if (elementName == null) {
                throw new SOAPException("binding must refer, in each of its soapbind:fault elements, only to wsdl:part elements that have been defined using attribute 'element': " + this.binding);
            }
            SOAPElement element = XmlUtil.getElement(detail, elementName);
            if (element == null) continue;
            String faultName = wsdlFault.getName();
            BindingFault bindFault = bindOperation.getBindingFault(faultName);
            SOAPFault soapBindFault = (SOAPFault)WsdlUtil.getExtension(bindFault.getExtensibilityElements(), SOAPConstants.Q_ELEM_SOAP_FAULT);
            if (soapBindFault.getName() == null) {
                throw new SOAPException("binding must have attribute 'name' specified on all contained soapbind:fault elements: " + this.binding);
            }
            if (!soapBindFault.getName().equals(faultName)) {
                throw new SOAPException("value of attribute 'name' on a soapbind:fault element must match the value of attribute 'name' on its parent wsdl:fault element: " + this.binding);
            }
            if (!"literal".equals(soapBindFault.getUse())) {
                throw new SOAPException("binding must use value 'literal' for attribute 'use' in all soapbind:fault elements: " + this.binding);
            }
            Element part = XmlUtil.createElement(elementName);
            parts.put(wsdlPart.getName(), part);
            XmlUtil.copy(part, element);
            return wsdlFault;
        }
        throw new SOAPException("no wsdl fault matches the detail element content: " + detail);
    }

    static {
        $assertionsDisabled = !SoapFormatter.class.desiredAssertionStatus();
    }
}

