/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render;

import java.awt.Color;
import java.util.List;
import org.apache.fop.area.Area;
import org.apache.fop.area.Trait;
import org.apache.fop.fonts.Font;
import org.apache.fop.fonts.FontInfo;
import org.apache.fop.fonts.FontSetup;
import org.apache.fop.fonts.FontTriplet;
import org.apache.fop.render.AbstractRenderer;
import org.apache.fop.render.DefaultFontResolver;

public abstract class PrintRenderer
extends AbstractRenderer {
    protected FontInfo fontInfo;
    protected List fontList = null;

    public void setupFontInfo(FontInfo inFontInfo) {
        this.fontInfo = inFontInfo;
        DefaultFontResolver resolver = new DefaultFontResolver(this.userAgent);
        FontSetup.setup(this.fontInfo, this.fontList, resolver, this.userAgent.getFactory().isBase14KerningEnabled());
    }

    protected String getInternalFontNameForArea(Area area) {
        FontTriplet triplet = (FontTriplet)area.getTrait(Trait.FONT);
        return this.fontInfo.getInternalFontKey(triplet);
    }

    protected Font getFontFromArea(Area area) {
        FontTriplet triplet = (FontTriplet)area.getTrait(Trait.FONT);
        int size = (Integer)area.getTrait(Trait.FONT_SIZE);
        return this.fontInfo.getFontInstance(triplet, size);
    }

    protected Color lightenColor(Color col, float factor) {
        float[] cols = new float[3];
        cols = col.getColorComponents(cols);
        if (factor > 0.0f) {
            cols[0] = (float)((double)cols[0] + (1.0 - (double)cols[0]) * (double)factor);
            cols[1] = (float)((double)cols[1] + (1.0 - (double)cols[1]) * (double)factor);
            cols[2] = (float)((double)cols[2] + (1.0 - (double)cols[2]) * (double)factor);
        } else {
            cols[0] = cols[0] - cols[0] * -factor;
            cols[1] = cols[1] - cols[1] * -factor;
            cols[2] = cols[2] - cols[2] * -factor;
        }
        return new Color(cols[0], cols[1], cols[2]);
    }
}

