/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.rtf.rtflib.rtfdoc;

import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;

public class RtfStringConverter {
    private static final RtfStringConverter INSTANCE = new RtfStringConverter();
    private static final Map SPECIAL_CHARS;
    private static final Character DBLQUOTE;
    private static final Character QUOTE;
    private static final Character SPACE;

    private RtfStringConverter() {
    }

    public static RtfStringConverter getInstance() {
        return INSTANCE;
    }

    public void writeRtfString(Writer w, String str) throws IOException {
        if (str == null) {
            return;
        }
        for (int i = 0; i < str.length(); ++i) {
            Character c = new Character(str.charAt(i));
            Character d = i != 0 ? new Character(str.charAt(i - 1)) : new Character(str.charAt(i));
            String replacement = c.equals(DBLQUOTE) && d.equals(SPACE) ? "ldblquote" : (c.equals(QUOTE) && d.equals(SPACE) ? "lquote" : (String)SPECIAL_CHARS.get(c));
            if (replacement != null) {
                w.write(92);
                w.write(replacement);
                w.write(32);
                continue;
            }
            if (c.charValue() > '\u007f') {
                w.write("\\u");
                w.write(Integer.toString(c.charValue()));
                w.write("\\'3f");
                continue;
            }
            w.write(c.charValue());
        }
    }

    static {
        DBLQUOTE = new Character('\"');
        QUOTE = new Character('\'');
        SPACE = new Character(' ');
        SPECIAL_CHARS = new HashMap();
        SPECIAL_CHARS.put(new Character('\t'), "tab");
        SPECIAL_CHARS.put(new Character('\n'), "line");
        SPECIAL_CHARS.put(new Character('\''), "rquote");
        SPECIAL_CHARS.put(new Character('\"'), "rdblquote");
        SPECIAL_CHARS.put(new Character('\\'), "\\");
        SPECIAL_CHARS.put(new Character('{'), "{");
        SPECIAL_CHARS.put(new Character('}'), "}");
    }
}

