/*
 * Decompiled with CFR 0.152.
 */
package org.drools.common;

import org.drools.common.AgendaItem;
import org.drools.common.InternalAgendaGroup;
import org.drools.common.InternalRuleBase;
import org.drools.spi.Activation;
import org.drools.util.Iterator;
import org.drools.util.LinkedList;
import org.drools.util.LinkedListEntry;

public class ArrayAgendaGroup
implements InternalAgendaGroup {
    private static final long serialVersionUID = 400L;
    private final String name;
    private LinkedList[] array;
    private boolean active;
    private int size;
    private int index;
    private int lastIndex;

    public ArrayAgendaGroup(String name, InternalRuleBase ruleBase) {
        this.name = name;
        Integer integer = (Integer)ruleBase.getAgendaGroupRuleTotals().get(name);
        this.array = integer == null ? new LinkedList[0] : new LinkedList[integer.intValue()];
        this.index = this.array.length - 1;
        this.lastIndex = 0;
    }

    public String getName() {
        return this.name;
    }

    public void clear() {
        this.array = new LinkedList[this.array.length];
    }

    public int size() {
        return this.size;
    }

    public void add(Activation activation) {
        LinkedList list;
        AgendaItem item = (AgendaItem)activation;
        ++this.size;
        int seq = item.getSequenence();
        if (seq < this.index) {
            this.index = seq;
        }
        if (seq > this.lastIndex) {
            this.lastIndex = seq;
        }
        if ((list = this.array[seq]) == null) {
            this.array[item.getSequenence()] = list = new LinkedList();
        }
        list.add(new LinkedListEntry(activation));
    }

    public Activation getNext() {
        Activation activation = null;
        while (this.index <= this.lastIndex) {
            LinkedList list = this.array[this.index];
            if (list != null) {
                activation = (Activation)((LinkedListEntry)list.removeFirst()).getObject();
                if (list.isEmpty()) {
                    this.array[this.index++] = null;
                }
                --this.size;
                break;
            }
            ++this.index;
        }
        return activation;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean activate) {
        this.active = activate;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public Activation[] getActivations() {
        Activation[] activations = new Activation[this.size];
        int j = 0;
        for (int i = 0; i < this.array.length; ++i) {
            LinkedList list = this.array[i];
            if (list == null) continue;
            Iterator it = list.iterator();
            Activation activation = (Activation)((LinkedListEntry)it.next()).getObject();
            while (activation != null) {
                activations[j++] = activation;
                activation = (Activation)it.next();
            }
        }
        return activations;
    }

    public Activation[] getQueue() {
        return this.getActivations();
    }

    public String toString() {
        return "AgendaGroup '" + this.name + "'";
    }

    public boolean equal(Object object) {
        if (object == null || !(object instanceof ArrayAgendaGroup)) {
            return false;
        }
        return ((ArrayAgendaGroup)object).name.equals(this.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }
}

