/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import org.drools.base.ValueType;
import org.drools.base.evaluators.Operator;
import org.drools.common.InternalFactHandle;
import org.drools.common.InternalWorkingMemory;
import org.drools.reteoo.AlphaNode;
import org.drools.reteoo.ObjectSink;
import org.drools.reteoo.ObjectSinkNode;
import org.drools.reteoo.ObjectSinkNodeList;
import org.drools.reteoo.ObjectSinkPropagator;
import org.drools.rule.LiteralConstraint;
import org.drools.spi.AlphaNodeFieldConstraint;
import org.drools.spi.Evaluator;
import org.drools.spi.Extractor;
import org.drools.spi.FieldExtractor;
import org.drools.spi.FieldValue;
import org.drools.spi.PropagationContext;
import org.drools.util.LinkedList;
import org.drools.util.LinkedListNode;
import org.drools.util.ObjectHashMap;

public class CompositeObjectSinkAdapter
implements ObjectSinkPropagator {
    private static final long serialVersionUID = 400L;
    ObjectSinkNodeList otherSinks;
    ObjectSinkNodeList hashableSinks;
    LinkedList hashedFieldIndexes;
    ObjectHashMap hashedSinkMap;
    private HashKey hashKey = new HashKey();
    private final int alphaNodeHashingThreshold;

    public CompositeObjectSinkAdapter() {
        this(3);
    }

    public CompositeObjectSinkAdapter(int alphaNodeHashingThreshold) {
        this.alphaNodeHashingThreshold = alphaNodeHashingThreshold;
    }

    public void addObjectSink(ObjectSink sink) {
        LiteralConstraint literalConstraint;
        Evaluator evaluator;
        AlphaNode alphaNode;
        AlphaNodeFieldConstraint fieldConstraint;
        if (sink instanceof AlphaNode && (fieldConstraint = (alphaNode = (AlphaNode)sink).getConstraint()) instanceof LiteralConstraint && (evaluator = (literalConstraint = (LiteralConstraint)fieldConstraint).getEvaluator()).getOperator() == Operator.EQUAL) {
            int index = literalConstraint.getFieldExtractor().getIndex();
            FieldIndex fieldIndex = this.registerFieldIndex(index, literalConstraint.getFieldExtractor());
            if (fieldIndex.getCount() >= this.alphaNodeHashingThreshold) {
                if (!fieldIndex.isHashed()) {
                    this.hashSinks(fieldIndex);
                }
                FieldValue value = literalConstraint.getField();
                this.hashedSinkMap.put(new HashKey(index, value), sink, false);
            } else {
                if (this.hashableSinks == null) {
                    this.hashableSinks = new ObjectSinkNodeList();
                }
                this.hashableSinks.add((ObjectSinkNode)sink);
            }
            return;
        }
        if (this.otherSinks == null) {
            this.otherSinks = new ObjectSinkNodeList();
        }
        this.otherSinks.add((ObjectSinkNode)sink);
    }

    public void removeObjectSink(ObjectSink sink) {
        AlphaNode alphaNode;
        AlphaNodeFieldConstraint fieldConstraint;
        if (sink instanceof AlphaNode && (fieldConstraint = (alphaNode = (AlphaNode)sink).getConstraint()) instanceof LiteralConstraint) {
            LiteralConstraint literalConstraint = (LiteralConstraint)fieldConstraint;
            Evaluator evaluator = literalConstraint.getEvaluator();
            FieldValue value = literalConstraint.getField();
            if (evaluator.getOperator() == Operator.EQUAL) {
                int index = literalConstraint.getFieldExtractor().getIndex();
                FieldIndex fieldIndex = this.unregisterFieldIndex(index);
                if (fieldIndex.isHashed()) {
                    this.hashKey.setValue(index, value);
                    this.hashedSinkMap.remove(this.hashKey);
                    if (fieldIndex.getCount() <= this.alphaNodeHashingThreshold - 1) {
                        this.unHashSinks(fieldIndex);
                    }
                } else {
                    this.hashableSinks.remove((ObjectSinkNode)sink);
                }
                if (this.hashableSinks != null && this.hashableSinks.isEmpty()) {
                    this.hashableSinks = null;
                }
                return;
            }
        }
        this.otherSinks.remove((ObjectSinkNode)sink);
        if (this.otherSinks.isEmpty()) {
            this.otherSinks = null;
        }
    }

    public void hashSinks(FieldIndex fieldIndex) {
        int index = fieldIndex.getIndex();
        ArrayList<ObjectSinkNode> list = new ArrayList<ObjectSinkNode>();
        if (this.hashedSinkMap == null) {
            this.hashedSinkMap = new ObjectHashMap();
        }
        for (ObjectSinkNode sink = this.hashableSinks.getFirst(); sink != null; sink = sink.getNextObjectSinkNode()) {
            AlphaNode alphaNode = (AlphaNode)sink;
            AlphaNodeFieldConstraint fieldConstraint = alphaNode.getConstraint();
            LiteralConstraint literalConstraint = (LiteralConstraint)fieldConstraint;
            Evaluator evaluator = literalConstraint.getEvaluator();
            if (evaluator.getOperator() != Operator.EQUAL || index != literalConstraint.getFieldExtractor().getIndex()) continue;
            FieldValue value = literalConstraint.getField();
            list.add(sink);
            this.hashedSinkMap.put(new HashKey(index, value), sink);
        }
        Iterator it = list.iterator();
        while (it.hasNext()) {
            ObjectSinkNode sink = (ObjectSinkNode)it.next();
            this.hashableSinks.remove(sink);
        }
        if (this.hashableSinks.isEmpty()) {
            this.hashableSinks = null;
        }
        fieldIndex.setHashed(true);
    }

    public void unHashSinks(FieldIndex fieldIndex) {
        int index = fieldIndex.getIndex();
        ArrayList<Object> sinks = new ArrayList<Object>();
        org.drools.util.Iterator mapIt = this.hashedSinkMap.newIterator();
        ObjectHashMap.ObjectEntry e = (ObjectHashMap.ObjectEntry)mapIt.next();
        while (e != null) {
            sinks.add(e.getValue());
            e = (ObjectHashMap.ObjectEntry)mapIt.next();
        }
        Iterator iter = sinks.iterator();
        while (iter.hasNext()) {
            AlphaNode sink = (AlphaNode)iter.next();
            AlphaNode alphaNode = sink;
            AlphaNodeFieldConstraint fieldConstraint = alphaNode.getConstraint();
            LiteralConstraint literalConstraint = (LiteralConstraint)fieldConstraint;
            Evaluator evaluator = literalConstraint.getEvaluator();
            if (evaluator.getOperator() != Operator.EQUAL || index != literalConstraint.getFieldExtractor().getIndex()) continue;
            FieldValue value = literalConstraint.getField();
            if (this.hashableSinks == null) {
                this.hashableSinks = new ObjectSinkNodeList();
            }
            this.hashableSinks.add(sink);
            this.hashedSinkMap.remove(new HashKey(index, value));
        }
        if (this.hashedSinkMap.isEmpty()) {
            this.hashedSinkMap = null;
        }
        fieldIndex.setHashed(false);
    }

    private FieldIndex registerFieldIndex(int index, FieldExtractor fieldExtractor) {
        FieldIndex fieldIndex = null;
        if (this.hashedFieldIndexes == null) {
            this.hashedFieldIndexes = new LinkedList();
            fieldIndex = new FieldIndex(index, fieldExtractor);
            this.hashedFieldIndexes.add(fieldIndex);
        }
        if (fieldIndex == null) {
            fieldIndex = this.findFieldIndex(index);
        }
        if (fieldIndex == null) {
            fieldIndex = new FieldIndex(index, fieldExtractor);
            this.hashedFieldIndexes.add(fieldIndex);
        }
        fieldIndex.increaseCounter();
        return fieldIndex;
    }

    private FieldIndex unregisterFieldIndex(int index) {
        FieldIndex fieldIndex = this.findFieldIndex(index);
        fieldIndex.decreaseCounter();
        if (fieldIndex.getCount() == 0) {
            this.hashedFieldIndexes.remove(fieldIndex);
            if (this.hashedFieldIndexes.isEmpty()) {
                this.hashedFieldIndexes = null;
            }
        }
        return fieldIndex;
    }

    private FieldIndex findFieldIndex(int index) {
        for (FieldIndex node = (FieldIndex)this.hashedFieldIndexes.getFirst(); node != null; node = (FieldIndex)node.getNext()) {
            if (node.getIndex() != index) continue;
            return node;
        }
        return null;
    }

    public void propagateAssertObject(InternalFactHandle handle, PropagationContext context, InternalWorkingMemory workingMemory) {
        ObjectSinkNode sink;
        Object object = handle.getObject();
        if (this.hashedFieldIndexes != null) {
            for (FieldIndex fieldIndex = (FieldIndex)this.hashedFieldIndexes.getFirst(); fieldIndex != null; fieldIndex = (FieldIndex)fieldIndex.getNext()) {
                if (!fieldIndex.isHashed()) continue;
                int index = fieldIndex.getIndex();
                FieldExtractor extractor = fieldIndex.getFieldExtactor();
                this.hashKey.setValue(index, object, extractor);
                ObjectSink sink2 = (ObjectSink)this.hashedSinkMap.get(this.hashKey);
                if (sink2 == null) continue;
                sink2.assertObject(handle, context, workingMemory);
            }
        }
        if (this.hashableSinks != null) {
            for (sink = this.hashableSinks.getFirst(); sink != null; sink = sink.getNextObjectSinkNode()) {
                sink.assertObject(handle, context, workingMemory);
            }
        }
        if (this.otherSinks != null) {
            for (sink = this.otherSinks.getFirst(); sink != null; sink = sink.getNextObjectSinkNode()) {
                sink.assertObject(handle, context, workingMemory);
            }
        }
    }

    public void propagateRetractObject(InternalFactHandle handle, PropagationContext context, InternalWorkingMemory workingMemory, boolean useHash) {
        ObjectSinkNode sink;
        if (this.hashedFieldIndexes != null) {
            if (useHash && this.hashedSinkMap != null) {
                Object object = handle.getObject();
                for (FieldIndex fieldIndex = (FieldIndex)this.hashedFieldIndexes.getFirst(); fieldIndex != null; fieldIndex = (FieldIndex)fieldIndex.getNext()) {
                    if (!fieldIndex.isHashed()) continue;
                    int index = fieldIndex.getIndex();
                    FieldExtractor extractor = fieldIndex.getFieldExtactor();
                    this.hashKey.setValue(index, object, extractor);
                    ObjectSink sink2 = (ObjectSink)this.hashedSinkMap.get(this.hashKey);
                    if (sink2 == null) continue;
                    sink2.retractObject(handle, context, workingMemory);
                }
            } else if (this.hashedSinkMap != null) {
                org.drools.util.Iterator it = this.hashedSinkMap.newIterator();
                ObjectHashMap.ObjectEntry entry = (ObjectHashMap.ObjectEntry)it.next();
                while (entry != null) {
                    ObjectSink sink3 = (ObjectSink)entry.getValue();
                    sink3.retractObject(handle, context, workingMemory);
                    entry = (ObjectHashMap.ObjectEntry)it.next();
                }
            }
        }
        if (this.hashableSinks != null) {
            for (sink = this.hashableSinks.getFirst(); sink != null; sink = sink.getNextObjectSinkNode()) {
                sink.retractObject(handle, context, workingMemory);
            }
        }
        if (this.otherSinks != null) {
            for (sink = this.otherSinks.getFirst(); sink != null; sink = sink.getNextObjectSinkNode()) {
                sink.retractObject(handle, context, workingMemory);
            }
        }
    }

    public ObjectSink[] getSinks() {
        ObjectSinkNode sink;
        ArrayList<ObjectSink> list = new ArrayList<ObjectSink>();
        if (this.otherSinks != null) {
            for (sink = this.otherSinks.getFirst(); sink != null; sink = sink.getNextObjectSinkNode()) {
                list.add(sink);
            }
        }
        if (this.hashableSinks != null) {
            for (sink = this.hashableSinks.getFirst(); sink != null; sink = sink.getNextObjectSinkNode()) {
                list.add(sink);
            }
        }
        if (this.hashedSinkMap != null) {
            org.drools.util.Iterator it = this.hashedSinkMap.newIterator();
            ObjectHashMap.ObjectEntry entry = (ObjectHashMap.ObjectEntry)it.next();
            while (entry != null) {
                ObjectSink sink2 = (ObjectSink)entry.getValue();
                list.add(sink2);
                entry = (ObjectHashMap.ObjectEntry)it.next();
            }
        }
        return list.toArray(new ObjectSink[list.size()]);
    }

    public int size() {
        int size = 0;
        size += this.otherSinks != null ? this.otherSinks.size() : 0;
        size += this.hashableSinks != null ? this.hashableSinks.size() : 0;
        return size += this.hashedSinkMap != null ? this.hashedSinkMap.size() : 0;
    }

    public static class FieldIndex
    implements LinkedListNode {
        private static final long serialVersionUID = 400L;
        private final int index;
        private FieldExtractor fieldExtactor;
        private int count;
        private boolean hashed;
        private LinkedListNode previous;
        private LinkedListNode next;

        public FieldIndex(int index, FieldExtractor fieldExtractor) {
            this.index = index;
            this.fieldExtactor = fieldExtractor;
        }

        public FieldExtractor getFieldExtractor() {
            return this.fieldExtactor;
        }

        public int getIndex() {
            return this.index;
        }

        public int getCount() {
            return this.count;
        }

        public FieldExtractor getFieldExtactor() {
            return this.fieldExtactor;
        }

        public boolean isHashed() {
            return this.hashed;
        }

        public void setHashed(boolean hashed) {
            this.hashed = hashed;
        }

        public void increaseCounter() {
            ++this.count;
        }

        public void decreaseCounter() {
            --this.count;
        }

        public LinkedListNode getNext() {
            return this.next;
        }

        public LinkedListNode getPrevious() {
            return this.previous;
        }

        public void setNext(LinkedListNode next) {
            this.next = next;
        }

        public void setPrevious(LinkedListNode previous) {
            this.previous = previous;
        }
    }

    public static class HashKey
    implements Serializable {
        private static final long serialVersionUID = 400L;
        private static final byte OBJECT = 1;
        private static final byte LONG = 2;
        private static final byte DOUBLE = 3;
        private static final byte BOOL = 4;
        private int index;
        private byte type;
        private Object ovalue;
        private long lvalue;
        private boolean bvalue;
        private double dvalue;
        private int hashCode;

        public HashKey() {
        }

        public HashKey(int index, FieldValue value) {
            this.setValue(index, value);
        }

        public HashKey(int index, Object value, Extractor extractor) {
            this.setValue(index, value, extractor);
        }

        public int getIndex() {
            return this.index;
        }

        public void setValue(int index, Object value, Extractor extractor) {
            this.index = index;
            ValueType vtype = extractor.getValueType();
            if (vtype.isBoolean()) {
                this.bvalue = extractor.getBooleanValue(null, value);
                this.type = (byte)4;
                this.setHashCode(this.bvalue ? 1231 : 1237);
            } else if (vtype.isIntegerNumber()) {
                this.lvalue = extractor.getLongValue(null, value);
                this.type = (byte)2;
                this.setHashCode((int)(this.lvalue ^ this.lvalue >>> 32));
            } else if (vtype.isFloatNumber()) {
                this.dvalue = extractor.getDoubleValue(null, value);
                this.type = (byte)3;
                long temp = Double.doubleToLongBits(this.dvalue);
                this.setHashCode((int)(temp ^ temp >>> 32));
            } else {
                this.ovalue = extractor.getValue(null, value);
                this.type = 1;
                this.setHashCode(this.ovalue != null ? this.ovalue.hashCode() : 0);
            }
        }

        public void setValue(int index, FieldValue value) {
            this.index = index;
            if (value.isBooleanField()) {
                this.bvalue = value.getBooleanValue();
                this.type = (byte)4;
                this.setHashCode(this.bvalue ? 1231 : 1237);
            } else if (value.isIntegerNumberField()) {
                this.lvalue = value.getLongValue();
                this.type = (byte)2;
                this.setHashCode((int)(this.lvalue ^ this.lvalue >>> 32));
            } else if (value.isFloatNumberField()) {
                this.dvalue = value.getDoubleValue();
                this.type = (byte)3;
                long temp = Double.doubleToLongBits(this.dvalue);
                this.setHashCode((int)(temp ^ temp >>> 32));
            } else {
                this.ovalue = value.getValue();
                this.type = 1;
                this.setHashCode(this.ovalue != null ? this.ovalue.hashCode() : 0);
            }
        }

        private void setHashCode(int hashSeed) {
            int PRIME = 31;
            int result = 1;
            result = 31 * result + hashSeed;
            this.hashCode = result = 31 * result + this.index;
        }

        public boolean getBooleanValue() {
            switch (this.type) {
                case 4: {
                    return this.bvalue;
                }
                case 1: {
                    if (this.ovalue == null) {
                        return false;
                    }
                    if (this.ovalue instanceof Boolean) {
                        return (Boolean)this.ovalue;
                    }
                    if (this.ovalue instanceof String) {
                        return Boolean.valueOf((String)this.ovalue);
                    }
                    throw new ClassCastException("Can't convert " + this.ovalue.getClass() + " to a boolean value.");
                }
                case 2: {
                    throw new ClassCastException("Can't convert long to a boolean value.");
                }
                case 3: {
                    throw new ClassCastException("Can't convert double to a boolean value.");
                }
            }
            return false;
        }

        public long getLongValue() {
            switch (this.type) {
                case 4: {
                    return this.bvalue ? 1L : 0L;
                }
                case 1: {
                    if (this.ovalue == null) {
                        return 0L;
                    }
                    if (this.ovalue instanceof Number) {
                        return ((Number)this.ovalue).longValue();
                    }
                    if (this.ovalue instanceof String) {
                        return Long.parseLong((String)this.ovalue);
                    }
                    throw new ClassCastException("Can't convert " + this.ovalue.getClass() + " to a long value.");
                }
                case 2: {
                    return this.lvalue;
                }
                case 3: {
                    return (long)this.dvalue;
                }
            }
            return 0L;
        }

        public double getDoubleValue() {
            switch (this.type) {
                case 4: {
                    return this.bvalue ? 1.0 : 0.0;
                }
                case 1: {
                    if (this.ovalue == null) {
                        return 0.0;
                    }
                    if (this.ovalue instanceof Number) {
                        return ((Number)this.ovalue).doubleValue();
                    }
                    if (this.ovalue instanceof String) {
                        return Double.parseDouble((String)this.ovalue);
                    }
                    throw new ClassCastException("Can't convert " + this.ovalue.getClass() + " to a double value.");
                }
                case 2: {
                    return this.lvalue;
                }
                case 3: {
                    return this.dvalue;
                }
            }
            return 0.0;
        }

        public Object getObjectValue() {
            switch (this.type) {
                case 4: {
                    return this.bvalue ? Boolean.TRUE : Boolean.FALSE;
                }
                case 1: {
                    return this.ovalue;
                }
                case 2: {
                    return new Long(this.lvalue);
                }
                case 3: {
                    return new Double(this.dvalue);
                }
            }
            return null;
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object object) {
            HashKey other = (HashKey)object;
            switch (this.type) {
                case 4: {
                    return this.index == other.index && this.bvalue == other.getBooleanValue();
                }
                case 2: {
                    return this.index == other.index && this.lvalue == other.getLongValue();
                }
                case 3: {
                    return this.index == other.index && this.dvalue == other.getDoubleValue();
                }
                case 1: {
                    Object otherValue = other.getObjectValue();
                    if (this.ovalue != null && this.ovalue instanceof Number && otherValue instanceof Number) {
                        return this.index == other.index && ((Number)this.ovalue).doubleValue() == ((Number)otherValue).doubleValue();
                    }
                    return this.index == other.index && (this.ovalue == null ? otherValue == null : this.ovalue.equals(otherValue));
                }
            }
            return false;
        }
    }
}

