/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.edisax;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.apache.commons.lang.StringUtils;
import org.apache.xmlbeans.XmlException;
import org.milyn.assertion.AssertArgument;
import org.milyn.edisax.BufferedSegmentReader;
import org.milyn.edisax.EDIParseException;
import org.milyn.io.StreamUtils;
import org.milyn.schema.ediMessageMapping10.ComponentDocument;
import org.milyn.schema.ediMessageMapping10.DelimitersDocument;
import org.milyn.schema.ediMessageMapping10.EdimapDocument;
import org.milyn.schema.ediMessageMapping10.FieldDocument;
import org.milyn.schema.ediMessageMapping10.SegmentDocument;
import org.milyn.schema.ediMessageMapping10.SubComponentDocument;
import org.milyn.xml.XmlUtil;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.AttributesImpl;

public class EDIParser
implements XMLReader {
    private ContentHandler contentHandler;
    private int depth = 0;
    private static Attributes EMPTY_ATTRIBS = new AttributesImpl();
    private EdimapDocument.Edimap mappingModel;
    private DelimitersDocument.Delimiters delimiters;
    private BufferedSegmentReader segmentReader;
    private static final char[] indentChars = new String("\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t").toCharArray();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EdimapDocument.Edimap parseMappingModel(InputStream mappingConfigStream) throws IOException, SAXException {
        byte[] mappingConfigByte;
        AssertArgument.isNotNull((Object)mappingConfigStream, (String)"mapping");
        EdimapDocument.Edimap mappingModel = null;
        try {
            mappingConfigByte = StreamUtils.readStream((InputStream)mappingConfigStream);
        }
        finally {
            mappingConfigStream.close();
        }
        EDIParser.assertMappingConfigValid(new ByteArrayInputStream(mappingConfigByte));
        try {
            mappingModel = EdimapDocument.Factory.parse(new ByteArrayInputStream(mappingConfigByte)).getEdimap();
        }
        catch (XmlException e) {
            new SAXException("EDI Mapping Model parse failure.", (Exception)((Object)e));
        }
        DelimitersDocument.Delimiters delimiters = mappingModel.getDelimiters();
        delimiters.setSegment(XmlUtil.removeEntities((String)delimiters.getSegment()));
        delimiters.setField(XmlUtil.removeEntities((String)delimiters.getField()));
        delimiters.setComponent(XmlUtil.removeEntities((String)delimiters.getComponent()));
        delimiters.setSubComponent(XmlUtil.removeEntities((String)delimiters.getSubComponent()));
        return mappingModel;
    }

    protected static void assertMappingConfigValid(InputStream mappingConfigStream) throws IOException, SAXException {
        AssertArgument.isNotNull((Object)mappingConfigStream, (String)"mapping");
        SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        Schema schema = factory.newSchema(new StreamSource(EDIParser.class.getResourceAsStream("/schema/edi-message-mapping-1.0.xsd")));
        Validator validator = schema.newValidator();
        validator.validate(new StreamSource(mappingConfigStream));
    }

    public void setMappingModel(EdimapDocument.Edimap mappingModel) {
        AssertArgument.isNotNull((Object)mappingModel, (String)"mappingModel");
        this.mappingModel = mappingModel;
        this.delimiters = mappingModel.getDelimiters();
    }

    public void parse(InputSource ediInputSource) throws IOException, SAXException {
        if (this.contentHandler == null) {
            throw new IllegalStateException("'contentHandler' not set.  Cannot parse EDI stream.");
        }
        if (this.mappingModel == null) {
            throw new IllegalStateException("'mappingModel' not set.  Cannot parse EDI stream.");
        }
        this.segmentReader = new BufferedSegmentReader(ediInputSource, this.delimiters);
        this.contentHandler.startDocument();
        this.startElement(this.mappingModel.getSegments().getXmltag(), false);
        if (this.segmentReader.moveToNextSegment()) {
            this.mapSegments(this.mappingModel.getSegments().getSegmentArray());
            if (this.segmentReader.hasCurrentSegment()) {
                throw new EDIParseException(this.mappingModel, "Reached end of mapping model but there are more EDI segments in the incoming message.  Read " + this.segmentReader.getCurrentSegmentNumber() + " segment(s).");
            }
        }
        this.endElement(this.mappingModel.getSegments().getXmltag(), true);
        this.contentHandler.endDocument();
    }

    private void mapSegments(SegmentDocument.Segment[] expectedSegments) throws IOException, SAXException {
        int segmentMappingIndex = 0;
        int segmentProcessingCount = 0;
        if (expectedSegments.length == 0) {
            return;
        }
        while (segmentMappingIndex < expectedSegments.length && this.segmentReader.hasCurrentSegment()) {
            String[] currentSegmentFields;
            SegmentDocument.Segment expectedSegment = expectedSegments[segmentMappingIndex];
            int minOccurs = expectedSegment.getMinOccurs();
            int maxOccurs = expectedSegment.getMaxOccurs();
            if (maxOccurs < 0) {
                maxOccurs = Integer.MAX_VALUE;
            }
            if (minOccurs > maxOccurs) {
                maxOccurs = minOccurs;
            }
            if (!(currentSegmentFields = this.segmentReader.getCurrentSegmentFields())[0].equals(expectedSegment.getSegcode())) {
                if (segmentProcessingCount < minOccurs) {
                    throw new EDIParseException(this.mappingModel, "Must be a minimum of " + minOccurs + " instances of segment [" + expectedSegment.getSegcode() + "].  Currently at segment number " + this.segmentReader.getCurrentSegmentNumber() + ".");
                }
                ++segmentMappingIndex;
                segmentProcessingCount = 0;
                continue;
            }
            if (segmentProcessingCount >= maxOccurs) {
                throw new EDIParseException(this.mappingModel, "Maximum of " + maxOccurs + " instances of segment [" + expectedSegment.getSegcode() + "] exceeded.  Currently at segment number " + this.segmentReader.getCurrentSegmentNumber() + ".");
            }
            this.mapSegment(currentSegmentFields, expectedSegment);
            if (++segmentProcessingCount >= minOccurs || this.segmentReader.hasCurrentSegment()) continue;
            throw new EDIParseException(this.mappingModel, "Reached end of EDI message stream but there must be a minimum of " + minOccurs + " instances of segment [" + expectedSegment.getSegcode() + "].  Currently at segment number " + this.segmentReader.getCurrentSegmentNumber() + ".");
        }
    }

    private void mapSegment(String[] currentSegmentFields, SegmentDocument.Segment expectedSegment) throws IOException, SAXException {
        this.startElement(expectedSegment.getXmltag(), true);
        this.mapFields(currentSegmentFields, expectedSegment.getFieldArray(), expectedSegment.getSegcode());
        if (this.segmentReader.moveToNextSegment()) {
            this.mapSegments(expectedSegment.getSegmentArray());
        }
        this.endElement(expectedSegment.getXmltag(), true);
    }

    private void mapFields(String[] currentSegmentFields, FieldDocument.Field[] expectedFields, String segmentCode) throws SAXException {
        if (currentSegmentFields.length != expectedFields.length + 1) {
            throw new EDIParseException(this.mappingModel, "Segment [" + segmentCode + "] expected to contain " + expectedFields.length + " fields.  Actually contains " + (currentSegmentFields.length - 1) + " fields (not including segment code).  Currently at segment number " + this.segmentReader.getCurrentSegmentNumber() + ".");
        }
        for (int i = 0; i < expectedFields.length; ++i) {
            String fieldMessageVal = currentSegmentFields[i + 1];
            FieldDocument.Field expectedField = expectedFields[i];
            this.mapField(fieldMessageVal, expectedField, i, segmentCode);
        }
    }

    private void mapField(String fieldMessageVal, FieldDocument.Field expectedField, int fieldIndex, String segmentCode) throws SAXException {
        ComponentDocument.Component[] expectedComponents = expectedField.getComponentArray();
        this.startElement(expectedField.getXmltag(), true);
        if (expectedComponents.length != 0) {
            String[] currentFieldComponents = StringUtils.splitPreserveAllTokens((String)fieldMessageVal, (String)this.mappingModel.getDelimiters().getComponent());
            if (currentFieldComponents.length != expectedComponents.length) {
                throw new EDIParseException(this.mappingModel, "Segment [" + segmentCode + "], field " + (fieldIndex + 1) + " (" + expectedField.getXmltag() + ") expected to contain " + expectedComponents.length + " components.  Actually contains " + currentFieldComponents.length + " components.  Currently at segment number " + this.segmentReader.getCurrentSegmentNumber() + ".");
            }
            for (int i = 0; i < expectedComponents.length; ++i) {
                String componentMessageVal = currentFieldComponents[i];
                ComponentDocument.Component expectedComponent = expectedComponents[i];
                this.mapComponent(componentMessageVal, expectedComponent, fieldIndex, i, segmentCode, expectedField.getXmltag());
            }
            this.endElement(expectedField.getXmltag(), true);
        } else {
            this.contentHandler.characters(fieldMessageVal.toCharArray(), 0, fieldMessageVal.length());
            this.endElement(expectedField.getXmltag(), false);
        }
    }

    private void mapComponent(String componentMessageVal, ComponentDocument.Component expectedComponent, int fieldIndex, int componentIndex, String segmentCode, String field) throws SAXException {
        SubComponentDocument.SubComponent[] expectedSubComponents = expectedComponent.getSubComponentArray();
        this.startElement(expectedComponent.getXmltag(), true);
        if (expectedSubComponents.length != 0) {
            String[] currentComponentSubComponents = StringUtils.splitPreserveAllTokens((String)componentMessageVal, (String)this.mappingModel.getDelimiters().getSubComponent());
            if (currentComponentSubComponents.length != expectedSubComponents.length) {
                throw new EDIParseException(this.mappingModel, "Segment [" + segmentCode + "], field " + (fieldIndex + 1) + " (" + field + "), component " + (componentIndex + 1) + " (" + expectedComponent.getXmltag() + ") expected to contain " + expectedSubComponents.length + " sub-components.  Actually contains " + currentComponentSubComponents.length + " sub-components.  Currently at segment number " + this.segmentReader.getCurrentSegmentNumber() + ".");
            }
            for (int i = 0; i < expectedSubComponents.length; ++i) {
                this.startElement(expectedSubComponents[i].getXmltag(), true);
                this.contentHandler.characters(currentComponentSubComponents[i].toCharArray(), 0, currentComponentSubComponents[i].length());
                this.endElement(expectedSubComponents[i].getXmltag(), false);
            }
            this.endElement(expectedComponent.getXmltag(), true);
        } else {
            this.contentHandler.characters(componentMessageVal.toCharArray(), 0, componentMessageVal.length());
            this.endElement(expectedComponent.getXmltag(), false);
        }
    }

    private void startElement(String elementName, boolean indent) throws SAXException {
        if (indent) {
            this.indent();
        }
        this.contentHandler.startElement(null, elementName, "", EMPTY_ATTRIBS);
        ++this.depth;
    }

    private void endElement(String elementName, boolean indent) throws SAXException {
        --this.depth;
        if (indent) {
            this.indent();
        }
        this.contentHandler.endElement(null, elementName, "");
    }

    private void indent() throws SAXException {
        this.contentHandler.characters(indentChars, 0, this.depth + 1);
    }

    public void setContentHandler(ContentHandler contentHandler) {
        this.contentHandler = contentHandler;
    }

    public ContentHandler getContentHandler() {
        return this.contentHandler;
    }

    public void parse(String systemId) throws IOException, SAXException {
        throw new UnsupportedOperationException("Operation not supports by this reader.");
    }

    public boolean getFeature(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        return false;
    }

    public void setFeature(String name, boolean value) throws SAXNotRecognizedException, SAXNotSupportedException {
    }

    public DTDHandler getDTDHandler() {
        return null;
    }

    public void setDTDHandler(DTDHandler arg0) {
    }

    public EntityResolver getEntityResolver() {
        return null;
    }

    public void setEntityResolver(EntityResolver arg0) {
    }

    public ErrorHandler getErrorHandler() {
        return null;
    }

    public void setErrorHandler(ErrorHandler arg0) {
    }

    public Object getProperty(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        return null;
    }

    public void setProperty(String name, Object value) throws SAXNotRecognizedException, SAXNotSupportedException {
    }
}

