/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.ui.facelet;

import com.sun.facelets.Facelet;
import com.sun.facelets.compiler.Compiler;
import com.sun.facelets.compiler.SAXCompiler;
import com.sun.facelets.impl.DefaultFaceletFactory;
import com.sun.facelets.impl.DefaultResourceResolver;
import com.sun.facelets.impl.ResourceResolver;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import javax.faces.application.Application;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.jboss.seam.InterceptionType;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Intercept;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.core.Renderer;
import org.jboss.seam.mock.MockApplication;
import org.jboss.seam.mock.MockExternalContext;
import org.jboss.seam.mock.MockFacesContext;
import org.jboss.seam.ui.JSF;
import org.jboss.seam.util.Resources;

@Scope(value=ScopeType.STATELESS)
@Intercept(value=InterceptionType.NEVER)
@Name(value="org.jboss.seam.core.renderer")
@Install(value=true, precedence=0, classDependencies={"com.sun.facelets.Facelet"})
public class FaceletsRenderer
extends Renderer {
    public String render(String viewId) {
        if (FacesContext.getCurrentInstance() == null) {
            MockFacesContext mockFacesContext = new MockFacesContext((ExternalContext)new MockExternalContext(), (Application)new MockApplication()).setCurrent();
            mockFacesContext.createViewRoot();
        }
        FacesContext facesContext = FacesContext.getCurrentInstance();
        ResponseWriter originalWriter = facesContext.getResponseWriter();
        try {
            StringWriter stringWriter = new StringWriter();
            this.wrapResponseWriter(facesContext, stringWriter);
            this.renderFacelet(facesContext, this.faceletForURL(this.resourceURL(viewId)));
            String string = stringWriter.getBuffer().toString();
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (originalWriter != null) {
                facesContext.setResponseWriter(originalWriter);
            }
        }
    }

    protected URL resourceURL(String viewId) {
        URL url = Resources.getResource((String)viewId);
        if (url == null) {
            throw new IllegalArgumentException("resource doesn't exist: " + viewId);
        }
        return url;
    }

    protected Facelet faceletForURL(URL url) throws IOException {
        return new DefaultFaceletFactory((Compiler)new SAXCompiler(), (ResourceResolver)new DefaultResourceResolver()).getFacelet(url);
    }

    protected void wrapResponseWriter(FacesContext facesContext, Writer writer) {
        ResponseWriter responseWriter = facesContext.getRenderKit().createResponseWriter(writer, null, null);
        facesContext.setResponseWriter(responseWriter);
    }

    protected void renderFacelet(FacesContext facesContext, Facelet facelet) throws IOException {
        UIViewRoot root = facesContext.getViewRoot();
        facelet.apply(facesContext, (UIComponent)root);
        JSF.renderChildren(facesContext, (UIComponent)root);
    }
}

