/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.plugins;

import java.rmi.RemoteException;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import org.jboss.ejb.AllowedOperationsAssociation;
import org.jboss.ejb.EnterpriseContext;
import org.jboss.ejb.plugins.AbstractTxInterceptor;
import org.jboss.invocation.Invocation;
import org.jboss.tm.TxUtils;

abstract class AbstractTxInterceptorBMT
extends AbstractTxInterceptor {
    private ThreadLocal userTransaction = new ThreadLocal();
    protected boolean stateless = true;

    AbstractTxInterceptorBMT() {
    }

    public void create() throws Exception {
        super.create();
        RefAddr refAddr = new RefAddr("userTransaction"){
            private static final long serialVersionUID = -8228448967597474960L;

            public Object getContent() {
                return AbstractTxInterceptorBMT.this.userTransaction;
            }
        };
        Reference ref = new Reference("javax.transaction.UserTransaction", refAddr, new UserTxFactory().getClass().getName(), null);
        ((Context)new InitialContext().lookup("java:comp/")).bind("UserTransaction", (Object)ref);
    }

    public void stop() {
        try {
            ((Context)new InitialContext().lookup("java:comp/")).unbind("UserTransaction");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object invokeNext(Invocation mi) throws Exception {
        Transaction oldTransaction = mi.getTransaction();
        Object oldUserTx = this.userTransaction.get();
        Transaction threadTx = this.tm.suspend();
        try {
            Object object;
            EnterpriseContext ctx = (EnterpriseContext)mi.getEnterpriseContext();
            try {
                AllowedOperationsAssociation.pushInMethodFlag(IN_INTERCEPTOR_METHOD);
                this.userTransaction.set(ctx.getEJBContext().getUserTransaction());
            }
            finally {
                AllowedOperationsAssociation.popInMethodFlag();
            }
            Transaction beanTx = ctx.getTransaction();
            if (beanTx != null) {
                this.tm.resume(beanTx);
            }
            mi.setTransaction(beanTx);
            try {
                object = super.invokeNext(mi, false);
            }
            catch (Throwable throwable) {
                try {
                    if (this.stateless) {
                        this.checkStatelessDone();
                    } else {
                        this.checkBadStateful();
                    }
                }
                finally {
                    this.tm.suspend();
                }
                throw throwable;
            }
            try {
                if (this.stateless) {
                    this.checkStatelessDone();
                } else {
                    this.checkBadStateful();
                }
            }
            finally {
                this.tm.suspend();
            }
            return object;
        }
        finally {
            this.userTransaction.set(oldUserTx);
            mi.setTransaction(oldTransaction);
            if (threadTx != null) {
                this.tm.resume(threadTx);
            }
        }
    }

    private void checkStatelessDone() throws RemoteException {
        int status = 6;
        try {
            status = this.tm.getStatus();
        }
        catch (SystemException ex) {
            this.log.error((Object)"Failed to get status", (Throwable)ex);
        }
        switch (status) {
            case 0: 
            case 1: 
            case 7: 
            case 8: 
            case 9: {
                try {
                    this.tm.rollback();
                }
                catch (Exception ex) {
                    this.log.error((Object)"Failed to rollback", (Throwable)ex);
                }
            }
            case 2: {
                String msg = "Application error: BMT stateless bean " + this.container.getBeanMetaData().getEjbName() + " should complete transactions before" + " returning (ejb1.1 spec, 11.6.1)";
                this.log.error((Object)msg);
                throw new RemoteException(msg);
            }
        }
    }

    private void checkBadStateful() throws RemoteException {
        int status = 6;
        try {
            status = this.tm.getStatus();
        }
        catch (SystemException ex) {
            this.log.error((Object)"Failed to get status", (Throwable)ex);
        }
        switch (status) {
            case 1: 
            case 7: 
            case 8: 
            case 9: {
                try {
                    this.tm.rollback();
                }
                catch (Exception ex) {
                    this.log.error((Object)"Failed to rollback", (Throwable)ex);
                }
                String msg = "BMT stateful bean '" + this.container.getBeanMetaData().getEjbName() + "' did not complete user transaction properly status=" + TxUtils.getStatusAsString((int)status);
                this.log.error((Object)msg);
            }
        }
    }

    public static class UserTxFactory
    implements ObjectFactory {
        public Object getObjectInstance(Object ref, Name name, Context nameCtx, Hashtable environment) throws Exception {
            RefAddr refAddr = ((Reference)ref).get(0);
            ThreadLocal threadLocal = (ThreadLocal)refAddr.getContent();
            return threadLocal.get();
        }
    }
}

