/*
 * Decompiled with CFR 0.152.
 */
package org.sadun.jmx;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.LinkedList;
import java.util.List;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import org.sadun.jmx.NotificationMonitorMBean;

public class NotificationMonitor
implements MBeanRegistration,
NotificationMonitorMBean,
NotificationListener {
    private List notifications = new LinkedList();
    private int logSize = 100;
    private ObjectName mbeanName;

    public NotificationMonitor() {
        System.out.println("Notifications monitor v1.0 instance created");
    }

    public synchronized void handleNotification(Notification notification, Object handback) {
        System.out.println("Notification received: " + notification + " (total of " + this.notifications.size() + " registered so far)");
        if (this.notifications.size() > this.logSize) {
            this.notifications.remove(this.notifications.size());
        }
        this.notifications.add(0, notification);
    }

    public int getMaxLogSize() {
        return this.logSize;
    }

    public void setMaxLogSize(int logSize) {
        this.logSize = logSize;
    }

    public String listNotifications() {
        return this.head(-1);
    }

    public String tail(int n) {
        return this.list(n, false);
    }

    public int logSize() {
        return this.notifications.size();
    }

    public synchronized void cleanUp() {
        this.notifications.removeAll(this.notifications);
    }

    private synchronized String list(int n, boolean forward) {
        int l = this.notifications.size();
        if (n == -1) {
            n = l;
        }
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        for (int i = 0; i < n; ++i) {
            pw.println(this.notifications.get(forward ? i : l - i));
        }
        return sw.toString();
    }

    public String head(int n) {
        return this.list(n, true);
    }

    public void postDeregister() {
    }

    public void postRegister(Boolean arg0) {
    }

    public void preDeregister() throws Exception {
    }

    public ObjectName preRegister(MBeanServer arg0, ObjectName name) throws Exception {
        this.mbeanName = name;
        return name;
    }
}

