/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ftpserver.socketfactory;

import java.net.InetAddress;
import java.net.ServerSocket;
import org.apache.ftpserver.ftplet.Component;
import org.apache.ftpserver.ftplet.Configuration;
import org.apache.ftpserver.ftplet.FtpException;
import org.apache.ftpserver.interfaces.SocketFactory;
import org.apache.ftpserver.interfaces.Ssl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FtpSocketFactory
implements SocketFactory,
Component {
    private final Logger LOG = LoggerFactory.getLogger((Class)FtpSocketFactory.class);
    private InetAddress serverAddress;
    private int port;
    private Ssl ssl;

    public void configure(Configuration conf) throws FtpException {
        try {
            String serverAddress = conf.getString("address", null);
            if (serverAddress != null) {
                this.serverAddress = InetAddress.getByName(serverAddress);
            }
            this.port = conf.getInt("port", 21);
            Configuration sslConf = conf.subset("ssl");
            if (!sslConf.isEmpty()) {
                this.ssl = (Ssl)Class.forName("org.apache.ftpserver.ssl.DefaultSsl").newInstance();
            }
        }
        catch (Exception ex) {
            this.LOG.error("FtpSocketFactory.configure()", (Throwable)ex);
            throw new FtpException("FtpSocketFactory.configure()", (Throwable)ex);
        }
    }

    public ServerSocket createServerSocket() throws Exception {
        ServerSocket ssocket = null;
        ssocket = this.serverAddress == null ? new ServerSocket(this.port, 100) : new ServerSocket(this.port, 100, this.serverAddress);
        return ssocket;
    }

    public InetAddress getServerAddress() {
        return this.serverAddress;
    }

    public int getPort() {
        return this.port;
    }

    public Ssl getSSL() {
        return this.ssl;
    }

    public void dispose() {
    }
}

