/*
 * Decompiled with CFR 0.152.
 */
package org.h2.tools;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import org.h2.engine.Database;
import org.h2.message.Message;
import org.h2.security.SHA256;
import org.h2.store.FileLister;
import org.h2.store.FileStore;
import org.h2.util.FileUtils;

public class ChangePassword {
    private String dir;
    private String cipher;
    private byte[] decrypt;
    private byte[] encrypt;

    private void showUsage() {
        System.out.println("java " + this.getClass().getName() + " [-dir <dir>] [-db <database>] [-cipher <cipher>] [-decrypt <pwd>] [-encrypt <pwd>] [-quiet]");
    }

    public static void main(String[] args) throws SQLException {
        new ChangePassword().run(args);
    }

    private void run(String[] args) throws SQLException {
        String dir = ".";
        String cipher = null;
        char[] decryptPassword = null;
        char[] encryptPassword = null;
        String db = null;
        boolean quiet = false;
        for (int i = 0; args != null && i < args.length; ++i) {
            if (args[i].equals("-dir")) {
                dir = args[++i];
                continue;
            }
            if (args[i].equals("-cipher")) {
                cipher = args[++i];
                continue;
            }
            if (args[i].equals("-db")) {
                db = args[++i];
                continue;
            }
            if (args[i].equals("-decrypt")) {
                decryptPassword = args[++i].toCharArray();
                continue;
            }
            if (args[i].equals("-encrypt")) {
                encryptPassword = args[++i].toCharArray();
                continue;
            }
            if (args[i].equals("-quiet")) {
                quiet = true;
                continue;
            }
            this.showUsage();
            return;
        }
        if (encryptPassword == null && decryptPassword == null) {
            this.showUsage();
            return;
        }
        ChangePassword.execute(dir, db, cipher, decryptPassword, encryptPassword, quiet);
    }

    private static byte[] getFileEncryptionKey(char[] password) {
        if (password == null) {
            return null;
        }
        SHA256 sha = new SHA256();
        return sha.getKeyPasswordHash("file", password);
    }

    public static void execute(String dir, String db, String cipher, char[] decryptPassword, char[] encryptPassword, boolean quiet) throws SQLException {
        String fileName;
        int i;
        ChangePassword change = new ChangePassword();
        change.dir = dir;
        change.cipher = cipher;
        change.decrypt = ChangePassword.getFileEncryptionKey(decryptPassword);
        change.encrypt = ChangePassword.getFileEncryptionKey(encryptPassword);
        ArrayList files = FileLister.getDatabaseFiles(dir, db, false);
        for (i = 0; i < files.size(); ++i) {
            fileName = (String)files.get(i);
            String temp = dir + "/temp.db";
            FileUtils.delete(temp);
            FileUtils.rename(fileName, temp);
            FileUtils.rename(temp, fileName);
        }
        for (i = 0; i < files.size(); ++i) {
            fileName = (String)files.get(i);
            change.process(fileName);
        }
        if (files.size() == 0 && !quiet) {
            System.out.println("No database files found");
        }
    }

    private void process(String fileName) throws SQLException {
        boolean textStorage = Database.isTextStorage(fileName, false);
        byte[] magic = Database.getMagic(textStorage);
        FileStore in = this.decrypt == null ? FileStore.open(null, fileName, "r", magic) : FileStore.open(null, fileName, "r", magic, this.cipher, this.decrypt);
        in.init();
        this.copy(fileName, textStorage, in, this.encrypt);
    }

    private void copy(String fileName, boolean textStorage, FileStore in, byte[] key) throws SQLException {
        long remaining;
        String temp = this.dir + "/temp.db";
        FileUtils.delete(temp);
        byte[] magic = Database.getMagic(textStorage);
        FileStore out = key == null ? FileStore.open(null, temp, "rw", magic) : FileStore.open(null, temp, "rw", magic, this.cipher, key);
        out.init();
        byte[] buffer = new byte[4096];
        long total = remaining = in.length() - 48L;
        in.seek(48L);
        out.seek(48L);
        long time = System.currentTimeMillis();
        while (remaining > 0L) {
            if (System.currentTimeMillis() - time > 1000L) {
                System.out.println(fileName + ": " + (100L - 100L * remaining / total) + "%");
                time = System.currentTimeMillis();
            }
            int len = (int)Math.min((long)buffer.length, remaining);
            in.readFully(buffer, 0, len);
            out.write(buffer, 0, len);
            remaining -= (long)len;
        }
        try {
            in.close();
            out.close();
        }
        catch (IOException e) {
            throw Message.convertIOException(e, null);
        }
        FileUtils.delete(fileName);
        FileUtils.rename(temp, fileName);
    }
}

