/*
 * Decompiled with CFR 0.152.
 */
package groovy.net.xmlrpc;

import groovy.lang.Closure;
import groovy.lang.GString;
import groovy.lang.GroovyClassLoader;
import groovy.lang.GroovyObject;
import groovy.lang.GroovyObjectSupport;
import groovy.lang.GroovyRuntimeException;
import java.io.ByteArrayInputStream;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import uk.co.wilson.net.xmlrpc.XMLRPCFailException;

public class RPCServer
extends GroovyObjectSupport {
    protected final Map registeredMethods = Collections.synchronizedMap(new HashMap());
    protected Closure defaultMethod = null;
    protected Closure preCallMethod = null;
    protected Closure postCallMethod = null;
    protected Closure faultMethod = null;

    public Object getProperty(final String property) {
        return new GroovyObjectSupport(){
            private final StringBuffer propertyPrefix;
            {
                this.propertyPrefix = new StringBuffer(property + ".");
            }

            public Object getProperty(String property2) {
                this.propertyPrefix.append(property2).append('.');
                return this;
            }

            public void setProperty(String name, Object args) {
                RPCServer.this.setProperty(this.propertyPrefix + name, name, args);
            }
        };
    }

    public void setProperty(String methodName, Object method) {
        this.setProperty(methodName, methodName, method);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setProperty(String methodName, String javaMethodName, Object method) {
        Closure closure = null;
        if (method instanceof Closure) {
            try {
                closure = (Closure)((Closure)method).clone();
                closure.setDelegate(this);
            }
            catch (CloneNotSupportedException e) {}
        } else if (method instanceof Class) {
            int numberofParameters = this.getNumberOfParameters(9, ((Class)method).getMethods(), javaMethodName);
            if (numberofParameters == -1) throw new GroovyRuntimeException("No static method " + javaMethodName + " on class " + ((Class)method).getName());
            closure = this.makeMethodProxy(javaMethodName, numberofParameters, ((Class)method).getName());
        } else {
            int numberofParameters = this.getNumberOfParameters(1, method.getClass().getMethods(), javaMethodName);
            if (numberofParameters == -1) throw new GroovyRuntimeException("No method " + javaMethodName + " on class " + method.getClass().getName());
            closure = this.makeMethodProxy(javaMethodName, numberofParameters, "delegate");
            closure.setDelegate(method);
        }
        this.registeredMethods.put(methodName, closure);
    }

    private int getNumberOfParameters(int type, Method[] methods, String property) {
        boolean foundMatch = false;
        int numberofParameters = -1;
        for (int i = 0; i != methods.length; ++i) {
            if ((methods[i].getModifiers() & type) != type || !methods[i].getName().equals(property)) continue;
            if (foundMatch) {
                if (numberofParameters == methods[i].getParameterTypes().length) continue;
                throw new GroovyRuntimeException("More than one methods " + property + " on class " + methods[i].getDeclaringClass().getName() + " with different numbers of parameters");
            }
            foundMatch = true;
            numberofParameters = methods[i].getParameterTypes().length;
        }
        return numberofParameters;
    }

    private Closure makeMethodProxy(String methodName, int numberOfParameters, String qualifier) {
        String paramIn;
        String paramOut;
        if (numberOfParameters == 0) {
            paramOut = "";
            paramIn = "";
        } else {
            StringBuffer params = new StringBuffer();
            for (int i = 0; i != numberOfParameters; ++i) {
                params.append(", p" + i);
            }
            paramOut = params.delete(0, 2).toString();
            paramIn = paramOut + " -> ";
        }
        String generatedCode = "class X { public def closure = {" + paramIn + " " + qualifier + "." + methodName + "(" + paramOut + ") }}";
        try {
            ByteArrayInputStream in = new ByteArrayInputStream(generatedCode.getBytes());
            GroovyObject groovyObject = (GroovyObject)new GroovyClassLoader().parseClass(in, methodName).newInstance();
            return (Closure)groovyObject.getProperty("closure");
        }
        catch (Exception e) {
            throw new GroovyRuntimeException("Can't generate proxy for XML-RPC method " + methodName, e);
        }
    }

    public void returnFault(String msg, int code) throws XMLRPCFailException {
        throw new XMLRPCFailException(msg, code);
    }

    public void returnFault(GString msg, int code) throws XMLRPCFailException {
        this.returnFault(msg.toString(), code);
    }

    public void setupDefaultMethod(Closure defaultMethod) {
        if (defaultMethod != null) {
            this.defaultMethod = defaultMethod;
        }
    }

    public void setupPreCallMethod(Closure preCallMethod) {
        if (preCallMethod != null) {
            this.preCallMethod = preCallMethod;
        }
    }

    public void setupPostCallMethod(Closure postCallMethod) {
        if (postCallMethod != null) {
            this.postCallMethod = postCallMethod;
        }
    }

    public void setupFaultMethod(Closure faultMethod) {
        if (faultMethod != null) {
            this.faultMethod = faultMethod;
        }
    }
}

