/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.rowset;

import java.io.Serializable;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import javax.sql.RowSetMetaData;

public class OracleRowSetMetaData
implements RowSetMetaData,
Serializable {
    private int columnCount;
    private int[] nullable;
    private int[] columnDisplaySize;
    private int[] precision;
    private int[] scale;
    private int[] columnType;
    private boolean[] searchable;
    private boolean[] caseSensitive;
    private boolean[] readOnly;
    private boolean[] writable;
    private boolean[] definatelyWritable;
    private boolean[] currency;
    private boolean[] autoIncrement;
    private boolean[] signed;
    private String[] columnLabel;
    private String[] schemaName;
    private String[] columnName;
    private String[] tableName;
    private String[] columnTypeName;
    private String[] catalogName;
    private String[] columnClassName;

    OracleRowSetMetaData(int n) throws SQLException {
        this.columnCount = n;
        this.searchable = new boolean[this.columnCount];
        this.caseSensitive = new boolean[this.columnCount];
        this.readOnly = new boolean[this.columnCount];
        this.nullable = new int[this.columnCount];
        this.signed = new boolean[this.columnCount];
        this.columnDisplaySize = new int[this.columnCount];
        this.columnType = new int[this.columnCount];
        this.columnLabel = new String[this.columnCount];
        this.columnName = new String[this.columnCount];
        this.schemaName = new String[this.columnCount];
        this.precision = new int[this.columnCount];
        this.scale = new int[this.columnCount];
        this.tableName = new String[this.columnCount];
        this.columnTypeName = new String[this.columnCount];
        this.writable = new boolean[this.columnCount];
        this.definatelyWritable = new boolean[this.columnCount];
        this.currency = new boolean[this.columnCount];
        this.autoIncrement = new boolean[this.columnCount];
        this.catalogName = new String[this.columnCount];
        this.columnClassName = new String[this.columnCount];
        for (int i = 0; i < this.columnCount; ++i) {
            this.searchable[i] = false;
            this.caseSensitive[i] = false;
            this.readOnly[i] = false;
            this.nullable[i] = 1;
            this.signed[i] = false;
            this.columnDisplaySize[i] = 0;
            this.columnType[i] = 0;
            this.columnLabel[i] = "";
            this.columnName[i] = "";
            this.schemaName[i] = "";
            this.precision[i] = 0;
            this.scale[i] = 0;
            this.tableName[i] = "";
            this.columnTypeName[i] = "";
            this.writable[i] = false;
            this.definatelyWritable[i] = false;
            this.currency[i] = false;
            this.autoIncrement[i] = true;
            this.catalogName[i] = "";
            this.columnClassName[i] = "";
        }
    }

    OracleRowSetMetaData(ResultSetMetaData resultSetMetaData) throws SQLException {
        this.columnCount = resultSetMetaData.getColumnCount();
        this.searchable = new boolean[this.columnCount];
        this.caseSensitive = new boolean[this.columnCount];
        this.readOnly = new boolean[this.columnCount];
        this.nullable = new int[this.columnCount];
        this.signed = new boolean[this.columnCount];
        this.columnDisplaySize = new int[this.columnCount];
        this.columnType = new int[this.columnCount];
        this.columnLabel = new String[this.columnCount];
        this.columnName = new String[this.columnCount];
        this.schemaName = new String[this.columnCount];
        this.precision = new int[this.columnCount];
        this.scale = new int[this.columnCount];
        this.tableName = new String[this.columnCount];
        this.columnTypeName = new String[this.columnCount];
        this.writable = new boolean[this.columnCount];
        this.definatelyWritable = new boolean[this.columnCount];
        this.currency = new boolean[this.columnCount];
        this.autoIncrement = new boolean[this.columnCount];
        this.catalogName = new String[this.columnCount];
        this.columnClassName = new String[this.columnCount];
        for (int i = 0; i < this.columnCount; ++i) {
            this.searchable[i] = resultSetMetaData.isSearchable(i + 1);
            this.caseSensitive[i] = resultSetMetaData.isCaseSensitive(i + 1);
            this.readOnly[i] = resultSetMetaData.isReadOnly(i + 1);
            this.nullable[i] = resultSetMetaData.isNullable(i + 1);
            this.signed[i] = resultSetMetaData.isSigned(i + 1);
            this.columnDisplaySize[i] = resultSetMetaData.getColumnDisplaySize(i + 1);
            this.columnType[i] = resultSetMetaData.getColumnType(i + 1);
            this.columnLabel[i] = resultSetMetaData.getColumnLabel(i + 1);
            this.columnName[i] = resultSetMetaData.getColumnName(i + 1);
            this.schemaName[i] = resultSetMetaData.getSchemaName(i + 1);
            if (this.columnType[i] == 2 || this.columnType[i] == 2 || this.columnType[i] == -5 || this.columnType[i] == 3 || this.columnType[i] == 8 || this.columnType[i] == 6 || this.columnType[i] == 4) {
                this.precision[i] = resultSetMetaData.getPrecision(i + 1);
                this.scale[i] = resultSetMetaData.getScale(i + 1);
            } else {
                this.precision[i] = 0;
                this.scale[i] = 0;
            }
            this.tableName[i] = resultSetMetaData.getTableName(i + 1);
            this.columnTypeName[i] = resultSetMetaData.getColumnTypeName(i + 1);
            this.writable[i] = resultSetMetaData.isWritable(i + 1);
            this.definatelyWritable[i] = resultSetMetaData.isDefinitelyWritable(i + 1);
            this.currency[i] = resultSetMetaData.isCurrency(i + 1);
            this.autoIncrement[i] = resultSetMetaData.isAutoIncrement(i + 1);
            this.catalogName[i] = resultSetMetaData.getCatalogName(i + 1);
            this.columnClassName[i] = resultSetMetaData.getColumnClassName(i + 1);
        }
    }

    private void validateColumnIndex(int n) throws SQLException {
        if (n < 1 || n > this.columnCount) {
            throw new SQLException("Invalid column index : " + n);
        }
    }

    public int getColumnCount() throws SQLException {
        return this.columnCount;
    }

    public boolean isAutoIncrement(int n) throws SQLException {
        this.validateColumnIndex(n);
        return this.autoIncrement[n - 1];
    }

    public boolean isCaseSensitive(int n) throws SQLException {
        this.validateColumnIndex(n);
        return this.caseSensitive[n - 1];
    }

    public boolean isSearchable(int n) throws SQLException {
        this.validateColumnIndex(n);
        return this.searchable[n - 1];
    }

    public boolean isCurrency(int n) throws SQLException {
        this.validateColumnIndex(n);
        return this.currency[n - 1];
    }

    public int isNullable(int n) throws SQLException {
        this.validateColumnIndex(n);
        return this.nullable[n - 1];
    }

    public boolean isSigned(int n) throws SQLException {
        this.validateColumnIndex(n);
        return this.signed[n - 1];
    }

    public int getColumnDisplaySize(int n) throws SQLException {
        this.validateColumnIndex(n);
        return this.columnDisplaySize[n - 1];
    }

    public String getColumnLabel(int n) throws SQLException {
        this.validateColumnIndex(n);
        return this.columnLabel[n - 1];
    }

    public String getColumnName(int n) throws SQLException {
        this.validateColumnIndex(n);
        return this.columnName[n - 1];
    }

    public String getSchemaName(int n) throws SQLException {
        this.validateColumnIndex(n);
        return this.schemaName[n - 1];
    }

    public int getPrecision(int n) throws SQLException {
        this.validateColumnIndex(n);
        return this.precision[n - 1];
    }

    public int getScale(int n) throws SQLException {
        this.validateColumnIndex(n);
        return this.scale[n - 1];
    }

    public String getTableName(int n) throws SQLException {
        this.validateColumnIndex(n);
        return this.tableName[n - 1];
    }

    public String getCatalogName(int n) throws SQLException {
        this.validateColumnIndex(n);
        return this.catalogName[n - 1];
    }

    public int getColumnType(int n) throws SQLException {
        this.validateColumnIndex(n);
        return this.columnType[n - 1];
    }

    public String getColumnTypeName(int n) throws SQLException {
        this.validateColumnIndex(n);
        return this.columnTypeName[n - 1];
    }

    public boolean isReadOnly(int n) throws SQLException {
        this.validateColumnIndex(n);
        return this.readOnly[n - 1];
    }

    public boolean isWritable(int n) throws SQLException {
        this.validateColumnIndex(n);
        return this.writable[n - 1];
    }

    public boolean isDefinitelyWritable(int n) throws SQLException {
        this.validateColumnIndex(n);
        return this.definatelyWritable[n - 1];
    }

    public String getColumnClassName(int n) throws SQLException {
        this.validateColumnIndex(n);
        return this.columnClassName[n - 1];
    }

    public void setAutoIncrement(int n, boolean bl) throws SQLException {
        this.validateColumnIndex(n);
        this.autoIncrement[n - 1] = bl;
    }

    public void setCaseSensitive(int n, boolean bl) throws SQLException {
        this.validateColumnIndex(n);
        this.caseSensitive[n - 1] = bl;
    }

    public void setCatalogName(int n, String string) throws SQLException {
        this.validateColumnIndex(n);
        this.catalogName[n - 1] = string;
    }

    public void setColumnCount(int n) throws SQLException {
        this.columnCount = n;
    }

    public void setColumnDisplaySize(int n, int n2) throws SQLException {
        this.validateColumnIndex(n);
        this.columnDisplaySize[n - 1] = n2;
    }

    public void setColumnLabel(int n, String string) throws SQLException {
        this.validateColumnIndex(n);
        this.columnLabel[n - 1] = string;
    }

    public void setColumnName(int n, String string) throws SQLException {
        this.validateColumnIndex(n);
        this.columnName[n - 1] = string;
    }

    public void setColumnType(int n, int n2) throws SQLException {
        this.validateColumnIndex(n);
        this.columnType[n - 1] = n2;
    }

    public void setColumnTypeName(int n, String string) throws SQLException {
        this.validateColumnIndex(n);
        this.columnTypeName[n - 1] = string;
    }

    public void setCurrency(int n, boolean bl) throws SQLException {
        this.validateColumnIndex(n);
        this.currency[n - 1] = bl;
    }

    public void setNullable(int n, int n2) throws SQLException {
        this.validateColumnIndex(n);
        this.nullable[n - 1] = n2;
    }

    public void setPrecision(int n, int n2) throws SQLException {
        this.validateColumnIndex(n);
        this.precision[n - 1] = n2;
    }

    public void setScale(int n, int n2) throws SQLException {
        this.validateColumnIndex(n);
        this.scale[n - 1] = n2;
    }

    public void setSchemaName(int n, String string) throws SQLException {
        this.validateColumnIndex(n);
        this.schemaName[n - 1] = string;
    }

    public void setSearchable(int n, boolean bl) throws SQLException {
        this.validateColumnIndex(n);
        this.searchable[n - 1] = bl;
    }

    public void setSigned(int n, boolean bl) throws SQLException {
        this.validateColumnIndex(n);
        this.signed[n - 1] = bl;
    }

    public void setTableName(int n, String string) throws SQLException {
        this.validateColumnIndex(n);
        this.tableName[n - 1] = string;
    }
}

