/*
 * Decompiled with CFR 0.152.
 */
package org.mvel;

import java.io.Serializable;
import java.util.ArrayList;
import org.mvel.ASTIterator;
import org.mvel.ASTNode;
import org.mvel.util.StringAppender;

public class ASTArrayList
implements ASTIterator,
Serializable {
    private final ASTNode[] astNodes;
    private int length = 0;
    private int cursor = 0;

    public ASTArrayList(ASTArrayList fi) {
        this.astNodes = fi.astNodes;
        this.length = fi.length;
    }

    public ASTArrayList(ASTIterator map) {
        map.finish();
        if (map instanceof ASTArrayList) {
            this.astNodes = ((ASTArrayList)map).astNodes;
            this.length = ((ASTArrayList)map).astNodes.length;
        } else {
            ArrayList<ASTNode> astNodes = new ArrayList<ASTNode>();
            map.reset();
            while (map.hasMoreNodes()) {
                astNodes.add(map.nextNode());
            }
            this.length = astNodes.size();
            this.astNodes = astNodes.toArray(new ASTNode[this.length]);
        }
    }

    public void reset() {
        this.cursor = 0;
    }

    public ASTNode firstNode() {
        return this.astNodes[0];
    }

    public ASTNode nextNode() {
        if (this.cursor < this.length) {
            return this.astNodes[this.cursor++];
        }
        return null;
    }

    public void skipNode() {
        ++this.cursor;
    }

    public ASTNode peekNext() {
        if (this.cursor < this.length) {
            return this.astNodes[this.cursor + 1];
        }
        return null;
    }

    public ASTNode peekNode() {
        if (this.cursor < this.length) {
            return this.astNodes[this.cursor];
        }
        return null;
    }

    public ASTNode peekLast() {
        if (this.cursor > 0) {
            return this.astNodes[this.cursor - 1];
        }
        return null;
    }

    public ASTNode nodesBack(int offset) {
        if (this.cursor - offset >= 0) {
            return this.astNodes[this.cursor - offset];
        }
        return null;
    }

    public void back() {
        --this.cursor;
    }

    public boolean hasMoreNodes() {
        return this.cursor < this.length;
    }

    public String showNodeChain() {
        StringAppender sb = new StringAppender();
        for (int i = 0; i < this.length; ++i) {
            sb.append("(" + i + "): <<" + this.astNodes[i].getName() + ">> = <<" + this.astNodes[i].getLiteralValue() + ">> [" + (this.astNodes[i].getLiteralValue() != null ? this.astNodes[i].getLiteralValue().getClass() : "null") + "]").append("\n");
        }
        return sb.toString();
    }

    public int size() {
        return this.length;
    }

    public int index() {
        return this.cursor;
    }

    public void finish() {
    }
}

