/*
 * Decompiled with CFR 0.152.
 */
package org.mvel;

import java.util.regex.Pattern;
import org.mvel.ASTLinkedList;
import org.mvel.ASTNode;
import org.mvel.AbstractParser;
import org.mvel.CompileException;
import org.mvel.CompiledExpression;
import org.mvel.DataConversion;
import org.mvel.ParserContext;
import org.mvel.PropertyVerifier;
import org.mvel.Soundex;
import org.mvel.ast.LiteralNode;
import org.mvel.ast.Substatement;
import org.mvel.util.CompilerTools;
import org.mvel.util.ExecutionStack;
import org.mvel.util.ParseTools;
import org.mvel.util.PropertyTools;
import org.mvel.util.Stack;
import org.mvel.util.StringAppender;

public class ExpressionCompiler
extends AbstractParser {
    private final Stack stk = new ExecutionStack();
    private Class returnType;
    private boolean verifying = true;
    private boolean secondPassOptimization = false;
    private ParserContext pCtx;

    public CompiledExpression compile() {
        return this.compile(new ParserContext());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompiledExpression compile(ParserContext ctx) {
        if (this.debugSymbols) {
            ctx.setDebugSymbols(this.debugSymbols);
        } else if (ctx.isDebugSymbols()) {
            this.debugSymbols = true;
        }
        try {
            this.newContext(ctx);
            CompiledExpression compiledExpression = this._compile();
            return compiledExpression;
        }
        finally {
            this.removeContext();
            if (this.pCtx.isFatalError()) {
                ExpressionCompiler.contextControl(1, null, null);
                throw new CompileException("Failed to compile: " + this.pCtx.getErrorList().size() + " compilation error(s)", this.pCtx.getErrorList());
            }
        }
    }

    public CompiledExpression _compile() {
        ASTLinkedList astLinkedList = new ASTLinkedList();
        this.pCtx = this.getParserContext();
        this.debugSymbols = this.pCtx.isDebugSymbols();
        try {
            ASTNode tk;
            if (this.verifying) {
                this.pCtx.initializeTables();
            }
            this.fields |= 0x10;
            while ((tk = this.nextToken()) != null) {
                if (tk.fields == -1) {
                    astLinkedList.addTokenNode(tk);
                    continue;
                }
                this.returnType = tk.getEgressType();
                if (tk instanceof Substatement) {
                    ExpressionCompiler subCompiler = new ExpressionCompiler(tk.getNameAsArray(), this.pCtx);
                    tk.setAccessor(subCompiler._compile());
                    this.returnType = subCompiler.getReturnType();
                }
                if (tk.isLiteral() && tk.getLiteralValue() != LITERALS.get("this")) {
                    ASTNode tkOp = this.nextTokenSkipSymbols();
                    if (tkOp != null && tkOp.isOperator() && !tkOp.isOperator(28) && !tkOp.isOperator(29)) {
                        ASTNode tkLA = this.nextTokenSkipSymbols();
                        if (tkLA != null && tkLA.isLiteral()) {
                            ASTNode tkOp2;
                            this.stk.push(tk.getLiteralValue(), tkLA.getLiteralValue(), tkOp.getLiteralValue());
                            this.reduceTrinary();
                            boolean firstLA = true;
                            while ((tkOp2 = this.nextTokenSkipSymbols()) != null) {
                                if (!tkOp2.isOperator(tkOp.getOperator())) {
                                    astLinkedList.addTokenNode(new LiteralNode(this.stk.pop()), this.verify(this.pCtx, tkOp2));
                                    break;
                                }
                                ASTNode tkLA2 = this.nextTokenSkipSymbols();
                                if (tkLA2 != null && tkLA2.isLiteral()) {
                                    this.stk.push(tkLA2.getLiteralValue(), tkOp2.getLiteralValue());
                                    this.reduceTrinary();
                                    firstLA = false;
                                    continue;
                                }
                                if (firstLA) {
                                    astLinkedList.addTokenNode(new ASTNode(1, this.stk.pop()));
                                    break;
                                }
                                astLinkedList.addTokenNode(new ASTNode(1, this.stk.pop()), tkOp);
                                if (tkLA2 == null) break;
                                astLinkedList.addTokenNode(tkLA2);
                                break;
                            }
                            if (this.stk.isEmpty()) continue;
                            astLinkedList.addTokenNode(new ASTNode(1, this.stk.pop()));
                            continue;
                        }
                        astLinkedList.addTokenNode(this.verify(this.pCtx, tk), this.verify(this.pCtx, tkOp));
                        if (tkLA == null) continue;
                        astLinkedList.addTokenNode(this.verify(this.pCtx, tkLA));
                        continue;
                    }
                    astLinkedList.addTokenNode(this.verify(this.pCtx, tk));
                    if (tkOp == null) continue;
                    astLinkedList.addTokenNode(this.verify(this.pCtx, tkOp));
                    continue;
                }
                astLinkedList.addTokenNode(this.verify(this.pCtx, tk));
            }
            if (this.verifying) {
                this.pCtx.processTables();
            }
            astLinkedList.finish();
            return new CompiledExpression(CompilerTools.optimizeAST(astLinkedList, this.secondPassOptimization), ExpressionCompiler.getCurrentSourceFileName(), this.returnType, this.pCtx);
        }
        catch (Throwable e) {
            parserContext.set(null);
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new CompileException(e.getMessage(), e);
        }
    }

    protected ASTNode verify(ParserContext pCtx, ASTNode tk) {
        if (tk.isOperator() && (tk.isOperator(12) || tk.isOperator(13))) {
            this.secondPassOptimization = true;
        }
        if (tk.isDiscard() || (tk.fields & 5) != 0) {
            return tk;
        }
        if (this.verifying) {
            if (tk.isAssignment()) {
                String varName;
                int c;
                char[] assign = tk.getNameAsArray();
                for (c = 0; c < assign.length && assign[c] != '='; ++c) {
                }
                if (ExpressionCompiler.isReservedWord(varName = new String(assign, 0, c++).trim())) {
                    this.addFatalError("invalid assignment - variable name is a reserved keyword: " + varName);
                }
                new ExpressionCompiler(new String(assign, c, assign.length - c).trim())._compile();
                this.returnType = tk.getEgressType();
                pCtx.addVariable(varName, this.returnType);
            } else if (tk.isIdentifier()) {
                PropertyVerifier propVerifier = new PropertyVerifier(tk.getNameAsArray(), this.getParserContext());
                this.returnType = propVerifier.analyze();
                if (propVerifier.isResolvedExternally()) {
                    pCtx.addInput(tk.getAbsoluteName(), this.returnType);
                }
            }
        }
        return tk;
    }

    private void reduceTrinary() {
        Object v1 = null;
        Object v2 = null;
        try {
            while (this.stk.size() > 1) {
                Integer operator = (Integer)this.stk.pop();
                v1 = this.stk.pop();
                v2 = this.stk.pop();
                switch (operator) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: {
                        this.stk.push(ParseTools.doOperations(v2, operator, v1));
                        break;
                    }
                    case 12: {
                        this.stk.push((Boolean)v2 != false && (Boolean)v1 != false);
                        break;
                    }
                    case 13: {
                        this.stk.push((Boolean)v2 != false || (Boolean)v1 != false);
                        break;
                    }
                    case 14: {
                        if (!PropertyTools.isEmpty(v2) || !PropertyTools.isEmpty(v1)) {
                            this.stk.clear();
                            this.stk.push(!PropertyTools.isEmpty(v2) ? v2 : v1);
                            return;
                        }
                        this.stk.push(null);
                        break;
                    }
                    case 15: {
                        this.stk.push(Pattern.compile(String.valueOf(v1)).matcher(String.valueOf(v2)).matches());
                        break;
                    }
                    case 16: {
                        if (v1 instanceof Class) {
                            this.stk.push(((Class)v1).isInstance(v2));
                            break;
                        }
                        this.stk.push(Thread.currentThread().getContextClassLoader().loadClass(String.valueOf(v1)).isInstance(v2));
                        break;
                    }
                    case 35: {
                        if (v1 instanceof Class) {
                            this.stk.push(DataConversion.canConvert(v2.getClass(), (Class)v1));
                            break;
                        }
                        this.stk.push(DataConversion.canConvert(v2.getClass(), Thread.currentThread().getContextClassLoader().loadClass(String.valueOf(v1))));
                        break;
                    }
                    case 17: {
                        this.stk.push(ParseTools.containsCheck(v2, v1));
                        break;
                    }
                    case 21: {
                        this.stk.push(ExpressionCompiler.asInt(v2) & ExpressionCompiler.asInt(v1));
                        break;
                    }
                    case 22: {
                        this.stk.push(ExpressionCompiler.asInt(v2) | ExpressionCompiler.asInt(v1));
                        break;
                    }
                    case 23: {
                        this.stk.push(ExpressionCompiler.asInt(v2) ^ ExpressionCompiler.asInt(v1));
                        break;
                    }
                    case 25: {
                        this.stk.push(ExpressionCompiler.asInt(v2) << ExpressionCompiler.asInt(v1));
                        break;
                    }
                    case 27: {
                        int iv2 = ExpressionCompiler.asInt(v2);
                        if (iv2 < 0) {
                            iv2 *= -1;
                        }
                        this.stk.push(iv2 << ExpressionCompiler.asInt(v1));
                        break;
                    }
                    case 24: {
                        this.stk.push(ExpressionCompiler.asInt(v2) >> ExpressionCompiler.asInt(v1));
                        break;
                    }
                    case 26: {
                        this.stk.push(ExpressionCompiler.asInt(v2) >>> ExpressionCompiler.asInt(v1));
                        break;
                    }
                    case 18: {
                        this.stk.push(new StringAppender(String.valueOf(v2)).append(String.valueOf(v1)).toString());
                        break;
                    }
                    case 19: {
                        this.stk.push(Soundex.soundex(String.valueOf(v1)).equals(Soundex.soundex(String.valueOf(v2))));
                        break;
                    }
                    case 20: {
                        this.stk.push(Float.valueOf(PropertyTools.similarity(String.valueOf(v1), String.valueOf(v2))));
                    }
                }
            }
        }
        catch (ClassCastException e) {
            if ((this.fields & 0x1000) == 0) {
                this.fields |= 0x1000;
                ASTNode tk = this.nextToken();
                if (tk != null) {
                    this.stk.push(v1, this.nextToken(), tk.getOperator());
                    this.reduceTrinary();
                    return;
                }
            }
            throw new CompileException("syntax error or incomptable types (left=" + (v1 != null ? v1.getClass().getName() : "null") + ", right=" + (v2 != null ? v2.getClass().getName() : "null") + ")", this.expr, this.cursor, e);
        }
        catch (Exception e) {
            throw new CompileException("failed to subEval expression: <<" + new String(this.expr) + ">>", e);
        }
    }

    private static int asInt(Object o) {
        return (Integer)o;
    }

    public ExpressionCompiler(String expression) {
        this.setExpression(expression);
    }

    public ExpressionCompiler(String expression, boolean verifying) {
        this.setExpression(expression);
        this.verifying = verifying;
    }

    public ExpressionCompiler(char[] expression) {
        this.setExpression(expression);
    }

    ExpressionCompiler(char[] expression, ParserContext ctx) {
        this.setExpression(expression);
        this.pCtx = ctx;
    }

    public boolean isVerifying() {
        return this.verifying;
    }

    public void setVerifying(boolean verifying) {
        this.verifying = verifying;
    }

    public Class getReturnType() {
        return this.returnType;
    }

    public void setReturnType(Class returnType) {
        this.returnType = returnType;
    }

    public String getExpression() {
        return new String(this.expr);
    }

    public ParserContext getParserContextState() {
        return this.pCtx;
    }

    public void removeParserContext() {
        this.removeContext();
    }
}

