/*
 * Decompiled with CFR 0.152.
 */
package org.mvel.ast;

import org.mvel.ASTNode;
import org.mvel.ExecutableStatement;
import org.mvel.MVEL;
import org.mvel.ast.NestedStatement;
import org.mvel.integration.VariableResolverFactory;
import org.mvel.util.ParseTools;

public class IfNode
extends ASTNode
implements NestedStatement {
    protected char[] block;
    protected ExecutableStatement condition;
    protected ExecutableStatement nestedStatement;
    protected IfNode elseIf;
    protected ExecutableStatement elseBlock;

    public IfNode(char[] condition, char[] block, int fields) {
        super(condition, fields);
        this.block = block;
        if ((fields & 0x10) != 0) {
            this.condition = (ExecutableStatement)ParseTools.subCompileExpression(condition);
            this.nestedStatement = (ExecutableStatement)ParseTools.subCompileExpression(block);
        }
    }

    public Object getReducedValueAccelerated(Object ctx, Object thisValue, VariableResolverFactory factory) {
        if (((Boolean)this.condition.getValue(ctx, thisValue, factory)).booleanValue()) {
            return this.nestedStatement.getValue(ctx, thisValue, factory);
        }
        if (this.elseIf != null) {
            return this.elseIf.getReducedValueAccelerated(ctx, thisValue, factory);
        }
        if (this.elseBlock != null) {
            return this.elseBlock.getValue(ctx, thisValue, factory);
        }
        return Void.class;
    }

    public Object getReducedValue(Object ctx, Object thisValue, VariableResolverFactory factory) {
        if (((Boolean)MVEL.eval(this.name, ctx, factory)).booleanValue()) {
            return MVEL.eval(this.block, ctx, factory);
        }
        if (this.elseIf != null) {
            return this.elseIf.getReducedValue(ctx, thisValue, factory);
        }
        if (this.elseBlock != null) {
            return this.elseBlock.getValue(ctx, thisValue, factory);
        }
        return Void.class;
    }

    public ExecutableStatement getNestedStatement() {
        return this.nestedStatement;
    }

    public IfNode setElseIf(IfNode elseIf) {
        this.elseIf = elseIf;
        return this.elseIf;
    }

    public ExecutableStatement getElseBlock() {
        return this.elseBlock;
    }

    public IfNode setElseBlock(char[] block) {
        this.elseBlock = (ExecutableStatement)ParseTools.subCompileExpression(block);
        return this;
    }
}

