/*
 * Decompiled with CFR 0.152.
 */
package org.mvel.ast;

import org.mvel.ASTNode;
import org.mvel.CompileException;
import org.mvel.integration.VariableResolverFactory;
import org.mvel.util.ParseTools;

public class ImportNode
extends ASTNode {
    private Class importClass;

    public ImportNode(char[] expr, int fields) {
        super(expr, fields);
        try {
            this.importClass = Thread.currentThread().getContextClassLoader().loadClass(new String(expr));
        }
        catch (ClassNotFoundException e) {
            throw new CompileException("class not found: " + new String(expr));
        }
    }

    public Object getReducedValueAccelerated(Object ctx, Object thisValue, VariableResolverFactory factory) {
        return ParseTools.findClassImportResolverFactory(factory).addClass(this.importClass);
    }

    public Object getReducedValue(Object ctx, Object thisValue, VariableResolverFactory factory) {
        return this.getReducedValueAccelerated(ctx, thisValue, factory);
    }

    public Class getImportClass() {
        return this.importClass;
    }
}

