/*
 * Decompiled with CFR 0.152.
 */
package org.mvel.optimizers.impl.refl;

import java.lang.reflect.Method;
import org.mvel.AccessorNode;
import org.mvel.CompileException;
import org.mvel.DataConversion;
import org.mvel.integration.VariableResolverFactory;

public class DynamicSetterAccessor
implements AccessorNode {
    private AccessorNode nextNode;
    private final Method method;
    public static final Object[] EMPTY = new Object[0];

    public Object setValue(Object ctx, Object elCtx, VariableResolverFactory variableFactory, Object value) {
        try {
            return this.method.invoke(ctx, DataConversion.convert(value, this.method.getParameterTypes()[0]));
        }
        catch (Exception e) {
            throw new CompileException("error binding property", e);
        }
    }

    public Object getValue(Object ctx, Object elCtx, VariableResolverFactory vars) {
        return null;
    }

    public DynamicSetterAccessor(Method method) {
        this.method = method;
    }

    public Method getMethod() {
        return this.method;
    }

    public AccessorNode setNextNode(AccessorNode nextNode) {
        this.nextNode = nextNode;
        return this.nextNode;
    }

    public AccessorNode getNextNode() {
        return this.nextNode;
    }

    public String toString() {
        return this.method.getDeclaringClass().getName() + "." + this.method.getName();
    }
}

