/*
 * Decompiled with CFR 0.152.
 */
package org.mvel.tests;

import junit.framework.TestCase;
import org.mvel.CompiledExpression;
import org.mvel.ExpressionCompiler;
import org.mvel.MVEL;
import org.mvel.MVELRuntime;
import org.mvel.ParserContext;
import org.mvel.debug.DebugTools;
import org.mvel.debug.Debugger;
import org.mvel.debug.Frame;
import org.mvel.integration.impl.DefaultLocalVariableResolverFactory;

public class DebuggerTests
extends TestCase {
    private static int count;
    private static int a1;
    private static int a4;

    public void testDebuggerInvoke() {
        count = 0;
        MVELRuntime.resetDebugger();
        MVELRuntime.setThreadDebugger(new Debugger(){

            public int onBreak(Frame frame) {
                if (frame.getFactory().getVariableResolver("a1") != null) {
                    a1++;
                }
                if (frame.getFactory().getVariableResolver("a4") != null) {
                    a4++;
                    System.out.println("HEI " + frame.getLineNumber());
                }
                count++;
                return 0;
            }
        });
        String src = "a1=7;\na2=8;\na3=9;\na4=10;\na5=11;\na6=12;\na7=13;\na8=14;";
        ExpressionCompiler c = new ExpressionCompiler(src);
        c.setDebugSymbols(true);
        ParserContext ctx = new ParserContext();
        ctx.setSourceFile("mysource");
        CompiledExpression compexpr = c.compile(ctx);
        System.out.println(DebugTools.decompile(compexpr));
        MVELRuntime.registerBreakpoint(ctx.getSourceFile(), 1);
        MVELRuntime.registerBreakpoint(ctx.getSourceFile(), 3);
        MVELRuntime.registerBreakpoint(ctx.getSourceFile(), 7);
        DefaultLocalVariableResolverFactory factory = new DefaultLocalVariableResolverFactory();
        MVEL.executeDebugger(compexpr, null, factory);
        System.out.println(a1);
        System.out.println(a4);
        System.out.println(count);
        DebuggerTests.assertEquals((int)2, (int)a1);
        DebuggerTests.assertEquals((int)1, (int)a4);
        DebuggerTests.assertEquals((int)3, (int)count);
    }

    public void testDebuggerInvoke2() {
        count = 0;
        MVELRuntime.resetDebugger();
        MVELRuntime.setThreadDebugger(new Debugger(){

            public int onBreak(Frame frame) {
                count++;
                return 0;
            }
        });
        String src = "a1=7;\na2=8;\nSystem.out.println(\"h\");\nac=23;\nde=23;\nge=23;\ngef=34;";
        ExpressionCompiler c = new ExpressionCompiler(src);
        c.setDebugSymbols(true);
        ParserContext ctx = new ParserContext();
        ctx.setSourceFile("mysource");
        CompiledExpression compexpr = c.compile(ctx);
        System.out.println(DebugTools.decompile(compexpr));
        MVELRuntime.registerBreakpoint(ctx.getSourceFile(), 1);
        MVELRuntime.registerBreakpoint(ctx.getSourceFile(), 2);
        MVELRuntime.registerBreakpoint(ctx.getSourceFile(), 3);
        MVELRuntime.registerBreakpoint(ctx.getSourceFile(), 4);
        MVELRuntime.registerBreakpoint(ctx.getSourceFile(), 5);
        DefaultLocalVariableResolverFactory factory = new DefaultLocalVariableResolverFactory();
        MVEL.executeDebugger(compexpr, null, factory);
        System.out.println(count);
        DebuggerTests.assertEquals((int)5, (int)count);
    }

    static {
        a1 = 0;
        a4 = 0;
    }
}

