/*
 * Decompiled with CFR 0.152.
 */
package org.mvel.util;

public class StringAppender
implements CharSequence {
    private static final int DEFAULT_SIZE = 15;
    private char[] str;
    private int capacity;
    private int size = 0;

    public StringAppender() {
        this.capacity = 15;
        this.str = new char[15];
    }

    public StringAppender(int capacity) {
        this.capacity = capacity;
        this.str = new char[this.capacity];
    }

    public StringAppender(char c) {
        this.capacity = 15;
        char[] cArray = new char[15];
        this.str = cArray;
        cArray[0] = c;
    }

    public StringAppender(char[] s) {
        this.str = s;
        this.capacity = this.size = s.length;
    }

    public StringAppender(CharSequence s) {
        this.capacity = this.size = s.length();
        this.str = new char[this.size];
        for (int i = 0; i < this.str.length; ++i) {
            this.str[i] = s.charAt(i);
        }
    }

    public StringAppender(String s) {
        this.str = s.toCharArray();
        this.capacity = this.size = this.str.length;
    }

    public StringAppender append(char[] chars) {
        if (chars.length > this.capacity - this.size) {
            this.grow(chars.length);
        }
        int i = 0;
        while (i < chars.length) {
            this.str[this.size] = chars[i++];
            ++this.size;
        }
        this.size += chars.length;
        return this;
    }

    public StringAppender append(Object o) {
        return this.append(String.valueOf(o));
    }

    public StringAppender append(CharSequence s) {
        if (s.length() > this.capacity - this.size) {
            this.grow(s.length());
        }
        int i = 0;
        while (this.size < this.capacity) {
            this.str[this.size] = s.charAt(i++);
            ++this.size;
        }
        this.size += s.length();
        return this;
    }

    public StringAppender append(String s) {
        if (s == null) {
            return this;
        }
        int len = s.length();
        if (len > this.capacity - this.size) {
            this.grow(len);
        }
        s.getChars(0, len, this.str, this.size);
        this.size += len;
        return this;
    }

    public StringAppender append(char c) {
        if (this.size >= this.capacity) {
            this.grow(1);
        }
        this.str[this.size++] = c;
        return this;
    }

    public int length() {
        return this.size;
    }

    private void grow(int s) {
        if (this.capacity == 0) {
            this.capacity = 15;
        }
        char[] newArray = new char[this.capacity += s * 2];
        System.arraycopy(this.str, 0, newArray, 0, this.size);
        this.str = newArray;
    }

    public char[] getChars(int start, int count) {
        char[] chars = new char[count];
        System.arraycopy(this.str, start, chars, 0, count);
        return chars;
    }

    public char[] toChars() {
        char[] chars = new char[this.size];
        System.arraycopy(this.str, 0, chars, 0, this.size);
        return chars;
    }

    public String toString() {
        if (this.size == this.capacity) {
            return new String(this.str);
        }
        return new String(this.str, 0, this.size);
    }

    public char charAt(int index) {
        return this.str[index];
    }

    public CharSequence subSequence(int start, int end) {
        return new String(this.str, start, end - start);
    }
}

