/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpel.tools;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class FileUtil {
    private static ThreadLocal transferBufferLocal = new ThreadLocal(){

        protected Object initialValue() {
            return new byte[512];
        }
    };

    private FileUtil() {
    }

    public static void recursiveDelete(File dir) {
        File[] files = dir.listFiles();
        if (files == null) {
            return;
        }
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            if (file.isDirectory()) {
                FileUtil.recursiveDelete(file);
            }
            file.delete();
        }
        dir.delete();
    }

    public static void addDirectory(File dir, ZipOutputStream moduleSink, String prefix) throws IOException {
        File[] files = dir.listFiles();
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            if (file.isDirectory()) {
                FileUtil.addDirectory(file, moduleSink, prefix + '/' + file.getName());
                continue;
            }
            FileUtil.addFile(file, moduleSink, prefix);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addFile(File file, ZipOutputStream moduleSink, String prefix) throws IOException {
        FileInputStream fileSource = new FileInputStream(file);
        try {
            int length;
            moduleSink.putNextEntry(new ZipEntry(prefix + '/' + file.getName()));
            byte[] transferBuffer = (byte[])transferBufferLocal.get();
            while ((length = ((InputStream)fileSource).read(transferBuffer)) > 0) {
                moduleSink.write(transferBuffer, 0, length);
            }
            moduleSink.closeEntry();
        }
        finally {
            ((InputStream)fileSource).close();
        }
    }
}

