/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.ant;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.ConnectException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.types.FileSet;

public class DeployProcessToServerTask
extends MatchingTask {
    private static final String boundary = "AaB03x";
    String serverName = "localhost";
    String serverPort = "8080";
    String serverDeployer = "/jbpm-console/upload";
    String debug = null;
    File process = null;
    List fileSets = new ArrayList();

    public void setServerDeployer(String serverDeployer) {
        this.serverDeployer = serverDeployer;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public void setServerPort(String serverPort) {
        this.serverPort = serverPort;
    }

    public void setProcess(File process) {
        this.process = process;
    }

    public void setDebug(String debug) {
        this.debug = debug;
    }

    public void execute() throws BuildException {
        try {
            if (this.pingServerOK()) {
                if (this.process != null) {
                    int len;
                    this.log("deploying par " + this.process.getAbsolutePath() + " ...");
                    FileInputStream in = new FileInputStream(this.process);
                    ByteArrayOutputStream out = new ByteArrayOutputStream();
                    byte[] buf = new byte[1024];
                    while ((len = in.read(buf)) > 0) {
                        out.write(buf, 0, len);
                    }
                    out.flush();
                    if (this.debug != null) {
                        this.saveParFile("debug.par", out.toByteArray());
                    }
                    this.deployProcessWithServlet(this.serverName, this.serverPort, this.serverDeployer, out.toByteArray());
                    in.close();
                    this.log("deployment complete.");
                }
                if (this.fileSets.size() > 0) {
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    ZipOutputStream zipOutputStream = new ZipOutputStream(byteArrayOutputStream);
                    for (FileSet fileSet : this.fileSets) {
                        DirectoryScanner dirScanner = fileSet.getDirectoryScanner(this.getProject());
                        String[] fileSetFiles = dirScanner.getIncludedFiles();
                        for (int i = 0; i < fileSetFiles.length; ++i) {
                            String fileName = fileSetFiles[i];
                            File file = new File(fileName);
                            if (!file.isFile()) {
                                file = new File(dirScanner.getBasedir(), fileName);
                            }
                            this.log("adding to process archive " + file + " ...");
                            this.addFile(zipOutputStream, file);
                        }
                    }
                    zipOutputStream.close();
                    this.log("deploying par ...");
                    if (this.debug != null) {
                        this.saveParFile("debug.par", byteArrayOutputStream.toByteArray());
                    }
                    this.deployProcessWithServlet(this.serverName, this.serverPort, this.serverDeployer, byteArrayOutputStream.toByteArray());
                    this.log("deployment complete.");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BuildException("couldn't deploy process archives : " + e.getMessage());
        }
    }

    public void addFileset(FileSet fileSet) {
        this.fileSets.add(fileSet);
    }

    public void deployProcessWithServlet(String serverName, String serverPort, String serverDeployer, byte[] parBytes) throws Exception {
        int read;
        URL url = new URL("http://" + serverName + ":" + serverPort + serverDeployer);
        URLConnection urlConnection = url.openConnection();
        urlConnection.setDoInput(true);
        urlConnection.setDoOutput(true);
        urlConnection.setUseCaches(false);
        urlConnection.setRequestProperty("Content-Type", "multipart/form-data; boundary=AaB03x");
        DataOutputStream dataOutputStream = new DataOutputStream(urlConnection.getOutputStream());
        dataOutputStream.writeBytes("--AaB03x\r\n");
        dataOutputStream.writeBytes("Content-Disposition: form-data; name=\"definition\"; filename=\"dummy.par\"\r\n");
        dataOutputStream.writeBytes("Content-Type: application/x-zip-compressed\r\n\r\n");
        dataOutputStream.write(parBytes);
        dataOutputStream.writeBytes("\r\n--AaB03x--\r\n");
        dataOutputStream.flush();
        dataOutputStream.close();
        InputStream inputStream = urlConnection.getInputStream();
        StringBuffer result = new StringBuffer();
        while ((read = inputStream.read()) != -1) {
            result.append((char)read);
        }
    }

    public void addFile(ZipOutputStream zos, File file) throws IOException {
        int read;
        byte[] buff = new byte[256];
        if (!file.exists()) {
            return;
        }
        FileInputStream is = new FileInputStream(file);
        zos.putNextEntry(new ZipEntry(file.getName()));
        while ((read = ((InputStream)is).read(buff)) != -1) {
            zos.write(buff, 0, read);
        }
    }

    private void saveParFile(String fileName, byte[] parBytes) throws IOException {
        File file = new File(fileName);
        if (!file.exists()) {
            file.createNewFile();
        }
        FileOutputStream fos = new FileOutputStream(file);
        fos.write(parBytes);
        fos.close();
    }

    public boolean pingServerOK() {
        URL url = null;
        try {
            int read;
            url = new URL("http://" + this.serverName + ":" + this.serverPort + this.serverDeployer);
            URLConnection urlConnection = url.openConnection();
            urlConnection.setDoOutput(true);
            InputStream inputStream = urlConnection.getInputStream();
            StringBuffer result = new StringBuffer();
            while ((read = inputStream.read()) != -1) {
                result.append((char)read);
            }
            return true;
        }
        catch (ConnectException e) {
            this.log("The server (" + url + ") could not be reached.");
            return false;
        }
        catch (Exception e) {
            this.log("An unexpected exception happened while testing the server (" + url + ") connection.");
            return false;
        }
    }
}

