/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.messaging.util;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class SafeUTF {
    private static final int CHUNK_SIZE = 16384;
    private static final byte NULL = 0;
    private static final byte NOT_NULL = 1;
    public static SafeUTF instance = new SafeUTF(16384);
    private int chunkSize;
    private int lastReadBufferSize;

    public int getLastReadBufferSize() {
        return this.lastReadBufferSize;
    }

    public SafeUTF(int chunkSize) {
        this.chunkSize = chunkSize;
    }

    public void safeWriteUTF(DataOutputStream out, String str) throws IOException {
        if (str == null) {
            out.writeByte(0);
        } else {
            int len = str.length();
            int numChunks = len == 0 ? 0 : (int)((short)((len - 1) / this.chunkSize + 1));
            out.writeByte(1);
            out.writeShort(numChunks);
            int i = 0;
            while (len > 0) {
                int beginCopy = i * this.chunkSize;
                int endCopy = len <= this.chunkSize ? beginCopy + len : beginCopy + this.chunkSize;
                String theChunk = str.substring(beginCopy, endCopy);
                out.writeUTF(theChunk);
                len -= this.chunkSize;
                ++i;
            }
        }
    }

    public String safeReadUTF(DataInputStream in) throws IOException {
        boolean isNull;
        boolean bl = isNull = in.readByte() == 0;
        if (isNull) {
            return null;
        }
        int numChunks = in.readShort();
        int bufferSize = this.chunkSize * numChunks;
        if (numChunks == 1) {
            int inSize = in.available();
            if (inSize <= 0) {
                inSize = 256;
            }
            this.lastReadBufferSize = bufferSize = Math.min(inSize, bufferSize);
        }
        StringBuffer buff = new StringBuffer(bufferSize);
        for (int i = 0; i < numChunks; ++i) {
            String s = in.readUTF();
            buff.append(s);
        }
        return buff.toString();
    }
}

