/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.stack;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jgroups.Event;
import org.jgroups.stack.Protocol;
import org.jgroups.stack.ProtocolObserver;
import org.jgroups.util.Queue;
import org.jgroups.util.QueueClosedException;

class DownHandler
extends Thread {
    private Queue mq = null;
    private Protocol handler = null;
    private ProtocolObserver observer = null;
    protected final Log log = LogFactory.getLog(this.getClass());

    public DownHandler(Queue mq, Protocol handler, ProtocolObserver observer) {
        this.mq = mq;
        this.handler = handler;
        this.observer = observer;
        if (handler != null) {
            this.setName("DownHandler (" + handler.getName() + ')');
        } else {
            this.setName("DownHandler");
        }
        this.setDaemon(true);
    }

    public void setObserver(ProtocolObserver observer) {
        this.observer = observer;
    }

    public void run() {
        while (!this.mq.closed()) {
            try {
                int type;
                Event evt = (Event)this.mq.remove();
                if (evt == null) {
                    if (!this.log.isWarnEnabled()) continue;
                    this.log.warn((Object)"removed null event");
                    continue;
                }
                if (this.observer != null && !this.observer.down(evt, this.mq.size()) || ((type = evt.getType()) == 61 || type == 63) && !this.handler.handleSpecialDownEvent(evt)) continue;
                this.handler.down(evt);
            }
            catch (QueueClosedException queue_closed) {
                break;
            }
            catch (Throwable e) {
                if (!this.log.isWarnEnabled()) continue;
                this.log.warn((Object)(this.getName() + " caught exception"), e);
            }
        }
    }
}

