/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.wsse.element;

import java.security.cert.X509Certificate;
import org.apache.xml.security.utils.XMLUtils;
import org.jboss.ws.wsse.InvalidSecurityHeaderException;
import org.jboss.ws.wsse.Util;
import org.jboss.ws.wsse.WSSecurityException;
import org.jboss.ws.wsse.element.BinarySecurityToken;
import org.jboss.ws.wsse.element.Reference;
import org.jboss.ws.wsse.element.X509Token;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class X509IssuerSerial
extends Reference {
    private Document doc;
    private String issuer;
    private String serial;
    private Element cachedElement;

    public X509IssuerSerial(Document doc, BinarySecurityToken token) throws WSSecurityException {
        this.doc = doc;
        this.referenceToken(token);
    }

    public X509IssuerSerial(Element element) throws WSSecurityException {
        this.doc = element.getOwnerDocument();
        if (!"X509Data".equals(element.getLocalName())) {
            throw new InvalidSecurityHeaderException("Invalid message, invalid local name on a X509Data element");
        }
        if ((element = Util.getFirstChildElement(element)) == null) {
            throw new InvalidSecurityHeaderException("X509DataElement empty");
        }
        if (!element.getLocalName().equals("X509IssuerSerial")) {
            throw new InvalidSecurityHeaderException("Only X509IssuerSerial is supported for an X509Data element");
        }
        if ((element = Util.getFirstChildElement(element)) == null) {
            throw new InvalidSecurityHeaderException("X509IssuerSerial empty");
        }
        while (element != null) {
            String name = element.getLocalName();
            if (name.equals("X509IssuerName")) {
                this.issuer = XMLUtils.getFullTextChildrenFromElement((Element)element);
            } else if (name.equals("X509SerialNumber")) {
                this.serial = XMLUtils.getFullTextChildrenFromElement((Element)element);
            }
            element = Util.getNextSiblingElement(element);
        }
        if (this.serial == null) {
            throw new InvalidSecurityHeaderException("X509SerialNumber missing from X509IssuerSerial");
        }
        if (this.issuer == null) {
            throw new InvalidSecurityHeaderException("X509IssuerName missing from X509IssuerSerial");
        }
    }

    public void referenceToken(BinarySecurityToken token) throws WSSecurityException {
        if (!(token instanceof X509Token)) {
            throw new WSSecurityException("X509IssuerSerial tried to reference something besides an X509 token");
        }
        X509Token x509 = (X509Token)token;
        X509Certificate cert = x509.getCert();
        this.issuer = ((Object)cert.getIssuerDN()).toString();
        this.serial = cert.getSerialNumber().toString();
    }

    public String getIssuer() {
        return this.issuer;
    }

    public String getSerial() {
        return this.serial;
    }

    public Document getDocument() {
        return this.doc;
    }

    public Element getElement() {
        if (this.cachedElement != null) {
            return this.cachedElement;
        }
        Element element = this.doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", "ds:X509Data");
        Element issuerSerial = this.doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", "ds:X509IssuerSerial");
        element.appendChild(issuerSerial);
        element = this.doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", "ds:X509IssuerName");
        element.appendChild(this.doc.createTextNode(this.issuer));
        issuerSerial.appendChild(element);
        element = this.doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", "ds:X509SerialNumber");
        element.appendChild(this.doc.createTextNode(this.serial));
        issuerSerial.appendChild(element);
        this.cachedElement = element;
        return this.cachedElement;
    }
}

