/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.submit.filters;

import com.eviware.soapui.impl.wsdl.WsdlRequest;
import com.eviware.soapui.impl.wsdl.submit.RequestFilter;
import com.eviware.soapui.model.iface.SubmitContext;
import com.eviware.soapui.support.xml.XmlUtils;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.ws.security.message.WSSecHeader;
import org.apache.ws.security.message.WSSecUsernameToken;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public class WsSecurityAuthenticationRequestFilter
implements RequestFilter {
    private static DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
    private static DocumentBuilder db;

    public void filterRequest(SubmitContext context, WsdlRequest wsdlRequest) {
        try {
            String pwType = wsdlRequest.getWssPasswordType();
            if (pwType == null || pwType.length() == 0 || "None".equals(pwType)) {
                return;
            }
            String request = (String)context.getProperty("requestContent");
            Document doc = db.parse(new InputSource(new StringReader(request)));
            WSSecUsernameToken wsa = new WSSecUsernameToken();
            if ("PasswordDigest".equals(pwType)) {
                wsa.setPasswordType("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordDigest");
            } else {
                wsa.setPasswordType("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordText");
            }
            wsa.setUserInfo(wsdlRequest.getUsername(), wsdlRequest.getPassword());
            WSSecHeader secHeader = new WSSecHeader();
            secHeader.insertSecurityHeader(doc);
            wsa.build(doc, secHeader);
            StringWriter writer = new StringWriter();
            XmlUtils.serializePretty(doc, (Writer)writer);
            context.setProperty("requestContent", writer.toString());
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    static {
        dbf.setValidating(false);
        dbf.setNamespaceAware(true);
        try {
            db = dbf.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
    }
}

