/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.testcase;

import com.eviware.soapui.impl.wsdl.testcase.WsdlTestCase;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlTestStep;
import com.eviware.soapui.model.support.AbstractSubmitContext;
import com.eviware.soapui.model.support.PropertiesMap;
import com.eviware.soapui.model.testsuite.TestCase;
import com.eviware.soapui.model.testsuite.TestRunContext;
import com.eviware.soapui.model.testsuite.TestRunner;
import com.eviware.soapui.model.testsuite.TestStep;

public class WsdlTestRunContext
extends AbstractSubmitContext
implements TestRunContext {
    private final TestRunner testRunner;
    private int currentStepIndex;
    private TestCase testCase;

    public WsdlTestRunContext(TestRunner testRunner, PropertiesMap properties) {
        super(properties);
        this.testRunner = testRunner;
    }

    public WsdlTestRunContext(TestStep testStep) {
        this(null, null);
        this.testCase = testStep.getTestCase();
        this.currentStepIndex = this.testCase.getIndexOfTestStep(testStep);
    }

    public TestStep getCurrentStep() {
        if (this.currentStepIndex < 0 || this.currentStepIndex >= this.getTestCase().getTestStepCount()) {
            return null;
        }
        return this.getTestCase().getTestStepAt(this.currentStepIndex);
    }

    public int getCurrentStepIndex() {
        return this.currentStepIndex;
    }

    public void setCurrentStep(int index) {
        this.currentStepIndex = index;
    }

    public TestRunner getTestRunner() {
        return this.testRunner;
    }

    public Object getProperty(String testStepName, String propertyName) {
        TestStep testStep = this.getTestCase().getTestStepByName(testStepName);
        return testStep == null ? null : testStep.getPropertyValue(propertyName);
    }

    public TestCase getTestCase() {
        return this.testRunner == null ? this.testCase : this.testRunner.getTestCase();
    }

    public Object getProperty(String name) {
        WsdlTestCase testCase = (WsdlTestCase)this.getTestCase();
        WsdlTestStep testStep = this.currentStepIndex >= 0 && this.currentStepIndex < testCase.getTestStepCount() ? testCase.getTestStepAt(this.currentStepIndex) : null;
        return this.getProperty(name, testStep, testCase);
    }

    public void reset() {
        this.resetProperties();
        this.currentStepIndex = 0;
    }
}

