<%@ page import="org.jboss.soa.esb.addressing.EPR" %>
<%@ page import="org.jboss.soa.esb.listeners.config.ServicePublisher" %>
<%@ page import="org.jboss.soa.esb.services.registry.Registry" %>
<%@ page import="org.jboss.soa.esb.services.registry.RegistryFactory" %>
<%@ page import="java.net.URI" %>
<%@ page import="java.util.ArrayList" %>
<%@ page import="java.util.List" %>
<html>
<head>
    <title>JBoss ESB - Service List</title>
    <link rel='stylesheet' href='../styles.css'>
</head>
<body>

<div class="pageSection">
    <h2>JBoss ESB Service Deployments</h2>
</div>

<div class="pageSection">
    <%
        List publishers = ServicePublisher.getServicePublishers();
        Registry registry = RegistryFactory.getRegistry();

        for (int i = 0; i < publishers.size(); i++) {
            ServicePublisher publisher = (ServicePublisher) publishers.get(i);
            String serviceCategory = publisher.getCategory();
            String serviceName = publisher.getServiceName();
            List eprs;

            try {
                eprs = (List) registry.findEPRs(serviceCategory, serviceName);
            }
            catch (Exception e) {
                // ignore for now - just return an empty list
                eprs = new ArrayList();
            }
    %>
    <fieldset>
        <legend><b><%=serviceCategory%>:<%=serviceName%>
        </b></legend>
        <%=publisher.getDescription()%>
        <%
            for (int ii = 0; ii < eprs.size(); ii++) {
                EPR epr = (EPR) eprs.get(ii);
                URI eprURI = URI.create(epr.getAddr().getAddress());
                String protocol = eprURI.getScheme();
                String relContractURI = "contract.jsp?serviceCat=" + serviceCategory + "&serviceName=" + serviceName + "&protocol=" + protocol;
                URI thisPage = URI.create(request.getRequestURL().toString());
                URI contractURI = thisPage.resolve(relContractURI);
        %>
        <fieldset>
            <legend><b><%=protocol.toUpperCase()%>
            </b></legend>

            <ul>
                <li><b>Endpoint</b>: <%=eprURI%>
                </li>
                <%
                    if (publisher.getContractPublisher() != null) {
                %>
                <li><b>Contract</b>: <a href="<%=relContractURI%>"><%=contractURI%>
                </a></li>
                <%
                }
                else {
                %>
                <li><b>Contract</b>: Unavailable</li>
                <%
                    }
                %>
            </ul>
        </fieldset>
        <%
            }
        %>
    </fieldset>
    <%
        }
    %>
</div>
</body>
</html>
