<?xml version="1.0"?>

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                version="1.0">
    <xsl:output method="xml" version="1.0" encoding="UTF-8" indent="yes"
                doctype-public="-//JBoss//DTD JBOSS Security Config 3.0//EN"
                doctype-system="http://www.jboss.org/j2ee/dtd/security_config.dtd"/>

    <xsl:template match="/policy">
        <xsl:comment>

            NOTICE

            This file was automatically generated by the installation of the SOA Platform into
            the Enterprise Application Platform. The original configuration file has been
            backed up in: old/login-config.xml

        </xsl:comment>

        <policy>
            <xsl:for-each select="/policy/*">
                <xsl:if test="@name!='soa'">
                    <xsl:if test="@name!='jmx-console'">
                        <xsl:if test="@name!='web-console'">
                            <xsl:comment>Loaded from orignal file: old/login-config.xml</xsl:comment>
                            <xsl:copy-of select="current()"/>
                            <xsl:comment>----</xsl:comment>
                        </xsl:if>
                    </xsl:if>
                </xsl:if>
            </xsl:for-each>

            <xsl:comment>SOA Platform Security Domain</xsl:comment>

            <application-policy name="soa">
                <authentication>
                    <login-module code="org.jboss.security.auth.spi.UsersRolesLoginModule"
                                  flag="required">
                        <module-option name="usersProperties">props/soa-users.properties</module-option>
                        <module-option name="rolesProperties">props/soa-roles.properties</module-option>
                    </login-module>
                </authentication>
            </application-policy>
            <application-policy name="jmx-console">
                <authentication>
                    <login-module code="org.jboss.security.auth.spi.UsersRolesLoginModule"
                                  flag="required">
                        <module-option name="usersProperties">props/soa-users.properties</module-option>
                        <module-option name="rolesProperties">props/soa-roles.properties</module-option>
                    </login-module>
                </authentication>
            </application-policy>
            <application-policy name="web-console">
                <authentication>
                    <login-module code="org.jboss.security.auth.spi.UsersRolesLoginModule"
                                  flag="required">
                        <module-option name="usersProperties">props/soa-users.properties</module-option>
                        <module-option name="rolesProperties">props/soa-roles.properties</module-option>
                    </login-module>
                </authentication>
            </application-policy>
        </policy>
    </xsl:template>

    <xsl:template match="/">

        <xsl:apply-templates/>
    </xsl:template>

</xsl:stylesheet>