/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and others contributors as indicated
 * by the @authors tag. All rights reserved.
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 * This program is distributed in the hope that it will be useful, but WITHOUT A
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License,
 * v.2.1 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA  02110-1301, USA.
 *
 * (C) 2005-2006, JBoss Inc.
 */
package org.jboss.soa.esb.listeners.config.mappers;

import org.w3c.dom.Element;
import org.jboss.soa.esb.listeners.config.xbeanmodel.ScheduledListenerDocument;
import org.jboss.soa.esb.listeners.ListenerTagNames;
import org.jboss.soa.esb.listeners.ScheduleListener;
import org.jboss.soa.esb.dom.YADOMUtil;

/**
 * Mapper for the {@link ScheduleListener}.
 * @author <a href="mailto:tom.fennelly@jboss.com">tom.fennelly@jboss.com</a>
 */
public class ScheduledListenerMapper {
    public static Element map(Element root, ScheduledListenerDocument.ScheduledListener scheduledListener) {
        Element listenerNode = YADOMUtil.addElement(root, scheduledListener.getName());

        listenerNode.setAttribute("event-processor", scheduledListener.getEventProcessor());
        listenerNode.setAttribute(ListenerTagNames.LISTENER_CLASS_TAG, ScheduleListener.class.getName());
        if (scheduledListener.isSetTransacted()) {
            listenerNode.setAttribute(ListenerTagNames.TRANSACTED_TAG, Boolean.toString(scheduledListener.getTransacted()));
        }

        // Map the <property> elements targeted at the listener - from the listener itself.
        MapperUtil.mapProperties(scheduledListener.getPropertyList(), listenerNode);

        return listenerNode;
    }
}
