/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and others contributors as indicated 
 * by the @authors tag. All rights reserved. 
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors. 
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 * This program is distributed in the hope that it will be useful, but WITHOUT A 
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A 
 * PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License,
 * v.2.1 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, 
 * MA  02110-1301, USA.
 * 
 * (C) 2005-2006,
 * @author schifest@heuristica.com.ar
 */

package org.jboss.soa.esb.message;

/**
 * The message properties hold arbitrary information in the form of
 * &lt;String,Object&gt; pairs
 * 
 */

public interface Properties
{
	/**
	 * getProperty(name)
	 * 
	 * @param name
	 *            String - name of property
	 * @return Object - the value stored under the specified name
	 */
	public Object getProperty(String name);

	/**
	 * getProperty(name,defaultVal)
	 * 
	 * @param name
	 *            String - name of property
	 * @param defaultVal
	 *            Object - value to return if no value found
	 * @return Object - the value stored under the specified name
	 */
	public Object getProperty(String name, Object defaultVal);

	/**
	 * setProperty(name,value)
	 * 
	 * @param name
	 *            String - name of property to store
	 * @param value
	 *            Object - value of property to store under specified name
	 * @return Object - the previous value of the specified name, or null if it
	 *         did not have one
	 */
	public Object setProperty(String name, Object value);

	/**
	 * remove(name)
	 * 
	 * @param name
	 *            String - name of property to remove
	 * @return Object - the previous value of the specified name, or null if it
	 *         did not have one
	 */
	public Object remove(String name);

	/**
	 * size()
	 * 
	 * @return int - Returns the number of properties in this object
	 */
	public int size();

	/**
	 * getNames()
	 * 
	 * @return String[] - containing the names of all properties
	 */
	public String[] getNames();

}
